/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_caelum.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.ars_caelum.ritual.StarterIslandRitual;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.RegistryHelper;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.CrushRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class ArsProviders {
    static String root = "ars_caelum";

    public static class PatchouliProvider
    extends com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider {
        public PatchouliProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void m_213708_(CachedOutput cache) throws IOException {
            for (AbstractRitual r : ArsNouveauAPI.getInstance().getRitualMap().values()) {
                if (!r.getRegistryName().m_135827_().equals("ars_caelum") || r instanceof StarterIslandRitual) continue;
                this.addRitualPage(r);
            }
            for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)patchouliPage.build(), (Path)patchouliPage.path());
            }
        }

        public void addRitualPage(AbstractRitual ritual) {
            PatchouliBuilder builder = new PatchouliBuilder(RITUALS, "item." + ritual.getRegistryName().m_135827_() + "." + ritual.getRegistryName().m_135815_()).withIcon(ritual.getRegistryName().toString()).withTextPage(ritual.getDescriptionKey()).withPage((IPatchouliPage)new CraftingPage(ritual.getRegistryName().toString()));
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.generator.m_123916_().resolve("data/" + ritual.getRegistryName().m_135827_() + "/patchouli_books/caelum_notes/en_us/entries/rituals/" + ritual.getRegistryName().m_135815_() + ".json")));
        }

        public String m_6055_() {
            return "Example Patchouli Datagen";
        }

        public Path getPath(ResourceLocation category, String fileName) {
            return this.generator.m_123916_().resolve("data/" + root + "/patchouli_books/example/en_us/entries/" + category.m_135815_() + "/" + fileName + ".json");
        }
    }

    public static class ImbuementProvider
    extends ImbuementRecipeProvider {
        public ImbuementProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void m_213708_(CachedOutput cache) throws IOException {
            Path output = this.generator.m_123916_();
            for (ImbuementRecipe g : this.recipes) {
                Path path = this.getRecipePath(output, g.m_6423_().m_135815_());
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)g.asRecipe(), (Path)path);
            }
        }

        protected Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipes/" + str + ".json");
        }

        public String m_6055_() {
            return "Example Imbuement";
        }
    }

    public static class EnchantingAppProvider
    extends ApparatusRecipeProvider {
        public EnchantingAppProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void m_213708_(CachedOutput cache) throws IOException {
            this.recipes.add(this.builder().withReagent(Ingredient.m_204132_((TagKey)Tags.Items.STORAGE_BLOCKS_DIAMOND)).withPedestalItem(8, (ItemLike)Items.f_42715_).withResult((ItemLike)Items.f_42716_).withSourceCost(10000).build());
            this.recipes.add(this.builder().withPedestalItem(3, (ItemLike)Items.f_151042_).buildEnchantmentRecipe(Enchantments.f_220304_, 1, 3000));
            this.recipes.add(this.builder().withPedestalItem(3, (ItemLike)Items.f_220195_).buildEnchantmentRecipe(Enchantments.f_220304_, 2, 6000));
            this.recipes.add(this.builder().withPedestalItem(3, (ItemLike)Items.f_220194_).buildEnchantmentRecipe(Enchantments.f_220304_, 3, 9000));
            Path output = this.generator.m_123916_();
            for (EnchantingApparatusRecipe g : this.recipes) {
                if (g == null) continue;
                Path path = EnchantingAppProvider.getRecipePath(output, g.m_6423_().m_135815_());
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)g.asRecipe(), (Path)path);
            }
        }

        protected static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipes/" + str + ".json");
        }

        public String m_6055_() {
            return "Example Apparatus";
        }
    }

    public static class GlyphProvider
    extends GlyphRecipeProvider {
        public GlyphProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void m_213708_(CachedOutput cache) throws IOException {
            Path output = this.generator.m_123916_();
            for (GlyphRecipe recipe : this.recipes) {
                Path path = GlyphProvider.getScribeGlyphPath(output, recipe.output.m_41720_());
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)recipe.asRecipe(), (Path)path);
            }
        }

        protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
            return pathIn.resolve("data/" + root + "/recipes/" + RegistryHelper.getRegistryName((Item)glyph).m_135815_() + ".json");
        }

        public String m_6055_() {
            return "Example Glyph Recipes";
        }
    }

    public static class CrushProvider
    extends CrushRecipeProvider {
        public DataGenerator generator;
        public List<CrushRecipe> replaceAn = new ArrayList<CrushRecipe>();

        public CrushProvider(DataGenerator generatorIn) {
            super(generatorIn);
            this.generator = generatorIn;
        }

        public void m_213708_(CachedOutput cache) throws IOException {
            Path path;
            CrushRecipe.CrushOutput goldNug = new CrushRecipe.CrushOutput(Items.f_42587_.m_7968_(), 0.2f, 3);
            CrushRecipe.CrushOutput ironNug = new CrushRecipe.CrushOutput(Items.f_42749_.m_7968_(), 0.2f, 3);
            CrushRecipe.CrushOutput copperNug = new CrushRecipe.CrushOutput(Items.f_151051_.m_7968_(), 0.2f, 1);
            CrushRecipe stone = new CrushRecipe("stone", Ingredient.m_204132_((TagKey)Tags.Items.STONE)).withItems(Items.f_41832_.m_7968_());
            stone.outputs.add(goldNug);
            stone.outputs.add(ironNug);
            stone.outputs.add(copperNug);
            CrushRecipe cobbleRecipe = new CrushRecipe("cobblestone", Ingredient.m_204132_((TagKey)Tags.Items.COBBLESTONE)).withItems(Items.f_41832_.m_7968_());
            cobbleRecipe.outputs.add(goldNug);
            cobbleRecipe.outputs.add(ironNug);
            cobbleRecipe.outputs.add(copperNug);
            this.replaceAn.add(cobbleRecipe);
            this.replaceAn.add(stone);
            this.replaceAn.add(new CrushRecipe("gravel", Ingredient.m_204132_((TagKey)Tags.Items.GRAVEL)).withItems(Items.f_41830_.m_7968_()).withItems(Items.f_42534_.m_7968_(), 0.05f).withItems(Items.f_42415_.m_7968_(), 0.01f).withItems(Items.f_42484_.m_7968_(), 0.02f));
            this.replaceAn.add(new CrushRecipe("sand", Ingredient.m_204132_((TagKey)Tags.Items.SAND)).withItems(Items.f_42461_.m_7968_(), 0.05f).withItems(Items.f_42451_.m_7968_(), 0.05f).skipBlockPlace());
            Path output = this.generator.m_123916_();
            for (CrushRecipe g : this.recipes) {
                path = CrushProvider.getRecipePath(output, g.m_6423_().m_135815_());
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)g.asRecipe(), (Path)path);
            }
            for (CrushRecipe g : this.replaceAn) {
                path = CrushProvider.getANPath(output, g.m_6423_().m_135815_());
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)g.asRecipe(), (Path)path);
            }
        }

        private static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/ars_caelum/recipes/" + str + ".json");
        }

        private static Path getANPath(Path pathIn, String str) {
            return pathIn.resolve("data/ars_nouveau/recipes/" + str + ".json");
        }
    }
}

