/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.util.AEColor;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ColoredItemDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.server.testworld.BlockEntityCustomizer;
import appeng.server.testworld.BuildAction;
import appeng.server.testworld.CableBuilder;
import appeng.server.testworld.DriveBuilder;
import appeng.server.testworld.PartCustomizer;
import appeng.server.testworld.PlaceBlockState;
import appeng.server.testworld.PlaceFacade;
import appeng.server.testworld.PlacePart;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.PostGridInitAction;
import appeng.server.testworld.SpawnEntityAction;
import appeng.server.testworld.Test;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;

public interface PlotBuilder {
    public void addBuildAction(BuildAction var1);

    public BoundingBox bb(String var1);

    public static String posToBb(BlockPos pos) {
        return pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
    }

    default public CableBuilder cable(BlockPos pos) {
        return this.cable(PlotBuilder.posToBb(pos));
    }

    default public CableBuilder cable(String bb) {
        return this.cable(bb, AEParts.GLASS_CABLE, AEColor.TRANSPARENT);
    }

    default public CableBuilder cable(String bb, ColoredItemDefinition<? extends IPartItem<?>> definition) {
        return this.cable(bb, definition, AEColor.TRANSPARENT);
    }

    default public CableBuilder cable(String bb, ColoredItemDefinition<? extends IPartItem<?>> definition, AEColor color) {
        return this.cable(bb, definition.item(color));
    }

    default public CableBuilder cable(String bb, IPartItem<?> what) {
        this.addBuildAction(new PlacePart(this.bb(bb), what, null));
        return new CableBuilder(this, bb);
    }

    default public CableBuilder denseCable(BlockPos pos) {
        return this.cable(PlotBuilder.posToBb(pos), (IPartItem)AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT));
    }

    default public void part(String bb, Direction side, ItemDefinition<? extends PartItem<?>> part) {
        this.addBuildAction(new PlacePart(this.bb(bb), (IPartItem)part.m_5456_(), side));
    }

    default public void part(BlockPos pos, Direction side, ItemDefinition<? extends PartItem<?>> part) {
        this.part(PlotBuilder.posToBb(pos), side, part);
    }

    default public <T extends IPart> void part(BlockPos pos, Direction side, ItemDefinition<? extends PartItem<T>> part, Consumer<T> partCustomizer) {
        this.part(PlotBuilder.posToBb(pos), side, part, partCustomizer);
    }

    default public <T extends IPart> void part(String bb, Direction side, ItemDefinition<? extends PartItem<T>> part, Consumer<T> partCustomizer) {
        this.addBuildAction(new PlacePart(this.bb(bb), (IPartItem)part.m_5456_(), side));
        this.addBuildAction(new PartCustomizer<T>(this.bb(bb), side, part, partCustomizer));
    }

    default public <T extends IPart> void facade(String bb, Direction side, ItemLike item) {
        this.addBuildAction(new PlaceFacade(this.bb(bb), item.m_5456_().m_7968_(), side));
    }

    default public void creativeEnergyCell(BlockPos pos) {
        this.creativeEnergyCell(PlotBuilder.posToBb(pos));
    }

    default public void creativeEnergyCell(String bb) {
        this.block(bb, AEBlocks.CREATIVE_ENERGY_CELL);
    }

    default public BlockPos leverOn(BlockPos pos, Direction side) {
        BlockPos leverPos = pos.m_121945_(side);
        AttachFace face = AttachFace.WALL;
        if (side == Direction.UP) {
            face = AttachFace.CEILING;
            side = Direction.EAST;
        } else if (side == Direction.DOWN) {
            face = AttachFace.FLOOR;
            side = Direction.EAST;
        }
        BlockState state = (BlockState)((BlockState)Blocks.f_50164_.m_49966_().m_61124_((Property)LeverBlock.f_53179_, (Comparable)face)).m_61124_((Property)LeverBlock.f_54117_, (Comparable)side);
        this.blockState(leverPos, state);
        return leverPos;
    }

    default public BlockPos buttonOn(BlockPos pos, Direction side) {
        BlockPos leverPos = pos.m_121945_(side);
        AttachFace face = AttachFace.WALL;
        if (side == Direction.UP) {
            face = AttachFace.CEILING;
            side = Direction.EAST;
        } else if (side == Direction.DOWN) {
            face = AttachFace.FLOOR;
            side = Direction.EAST;
        }
        BlockState state = (BlockState)((BlockState)Blocks.f_50710_.m_49966_().m_61124_((Property)ButtonBlock.f_53179_, (Comparable)face)).m_61124_((Property)ButtonBlock.f_54117_, (Comparable)side);
        this.blockState(leverPos, state);
        return leverPos;
    }

    default public void block(BlockPos pos, BlockDefinition<?> block) {
        this.block(PlotBuilder.posToBb(pos), block);
    }

    default public void block(String bb, BlockDefinition<?> block) {
        this.blockState(bb, block.block().m_49966_());
    }

    default public <T extends AEBaseBlockEntity> void blockEntity(BlockPos pos, BlockDefinition<? extends AEBaseEntityBlock<T>> block, Consumer<T> postProcessor) {
        this.blockEntity(PlotBuilder.posToBb(pos), block, postProcessor);
    }

    default public <T extends AEBaseBlockEntity> void blockEntity(String bb, BlockDefinition<? extends AEBaseEntityBlock<T>> block, Consumer<T> postProcessor) {
        this.blockState(bb, block.block().m_49966_());
        BlockEntityType<T> type = block.block().getBlockEntityType();
        this.addBuildAction(new BlockEntityCustomizer<T>(this.bb(bb), type, postProcessor));
    }

    default public void chest(BlockPos pos, ItemStack ... stacks) {
        this.chest(PlotBuilder.posToBb(pos), stacks);
    }

    default public void chest(String bb, ItemStack ... stacks) {
        this.block(bb, Blocks.f_50087_);
        this.customizeBlockEntity(bb, BlockEntityType.f_58918_, (T chest) -> {
            for (int i = 0; i < stacks.length; ++i) {
                chest.m_6836_(i, stacks[i]);
            }
        });
    }

    default public void filledHopper(String bb, Direction direction, ItemLike item) {
        ItemStack stack = new ItemStack(item);
        stack.m_41764_(stack.m_41741_());
        this.filledHopper(bb, direction, stack);
    }

    default public void filledHopper(String bb, Direction direction, ItemStack stack) {
        this.blockState(bb, (BlockState)Blocks.f_50332_.m_49966_().m_61124_((Property)HopperBlock.f_54021_, (Comparable)direction));
        this.customizeBlockEntity(bb, BlockEntityType.f_58933_, (T hopper) -> {
            for (int i = 0; i < hopper.m_6643_(); ++i) {
                hopper.m_6836_(i, stack.m_41777_());
            }
        });
    }

    default public void hopper(BlockPos pos, Direction direction, ItemStack ... stacks) {
        this.hopper(PlotBuilder.posToBb(pos), direction, stacks);
    }

    default public void hopper(BlockPos pos, Direction direction, ItemLike ... items) {
        this.hopper(pos, direction, (ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    default public void hopper(String bb, Direction direction, ItemStack ... stacks) {
        this.blockState(bb, (BlockState)Blocks.f_50332_.m_49966_().m_61124_((Property)HopperBlock.f_54021_, (Comparable)direction));
        this.customizeBlockEntity(bb, BlockEntityType.f_58933_, (T hopper) -> {
            for (int i = 0; i < stacks.length; ++i) {
                hopper.m_6836_(i, stacks[i]);
            }
        });
    }

    default public <T extends BlockEntity> void customizeBlockEntity(String bb, BlockEntityType<T> type, Consumer<T> consumer) {
        this.addBuildAction(new BlockEntityCustomizer<T>(this.bb(bb), type, consumer));
    }

    default public <T extends BlockEntity> void customizeBlockEntity(BlockPos pos, BlockEntityType<T> type, Consumer<T> consumer) {
        this.customizeBlockEntity(PlotBuilder.posToBb(pos), type, consumer);
    }

    default public void block(BlockPos pos, Block block) {
        this.block(PlotBuilder.posToBb(pos), block);
    }

    default public void block(String bb, Block block) {
        this.blockState(bb, block.m_49966_());
    }

    default public void fluid(String bb, Fluid fluid) {
        this.blockState(bb, fluid.m_76145_().m_76188_());
    }

    default public void blockState(BlockPos pos, BlockState blockState) {
        this.blockState(PlotBuilder.posToBb(pos), blockState);
    }

    default public void blockState(String bb, BlockState blockState) {
        this.addBuildAction(new PlaceBlockState(this.bb(bb), blockState));
    }

    public PlotBuilder transform(Function<BoundingBox, BoundingBox> var1);

    default public PlotBuilder offset(int x, int y, int z) {
        return this.transform(bb -> bb.m_71045_(x, y, z));
    }

    default public PlotBuilder offset(BlockPos pos) {
        return this.offset(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    default public void afterGridInitAt(String bb, BiConsumer<IGrid, IGridNode> consumer) {
        this.addBuildAction(new PostGridInitAction(this.bb(bb), consumer, true));
    }

    default public void afterGridInitAt(BlockPos pos, BiConsumer<IGrid, IGridNode> consumer) {
        this.afterGridInitAt(PlotBuilder.posToBb(pos), consumer);
    }

    default public void afterGridExistsAt(String bb, BiConsumer<IGrid, IGridNode> consumer) {
        this.addBuildAction(new PostGridInitAction(this.bb(bb), consumer, false));
    }

    default public void afterGridExistsAt(BlockPos pos, BiConsumer<IGrid, IGridNode> consumer) {
        this.afterGridExistsAt(PlotBuilder.posToBb(pos), consumer);
    }

    default public void storageDrive(BlockPos pos) {
        this.blockEntity(PlotBuilder.posToBb(pos), AEBlocks.DRIVE, (T drive) -> {
            InternalInventory cells = drive.getInternalInventory();
            cells.addItems(AEItems.ITEM_CELL_64K.stack());
            cells.addItems(AEItems.FLUID_CELL_64K.stack());
        });
    }

    default public DriveBuilder drive(BlockPos pos) {
        ArrayList<ItemStack> cells = new ArrayList<ItemStack>(10);
        this.blockEntity(PlotBuilder.posToBb(pos), AEBlocks.DRIVE, (T drive) -> {
            InternalInventory cellInv = drive.getInternalInventory();
            for (ItemStack cell : cells) {
                cellInv.addItems(cell);
            }
        });
        return new DriveBuilder(cells);
    }

    public Test test(Consumer<PlotTestHelper> var1);

    default public void fencedEntity(BlockPos pos, EntityType<?> entity) {
        this.fencedEntity(pos, entity, e -> {});
    }

    default public void fencedEntity(BlockPos pos, EntityType<?> entity, Consumer<Entity> postProcessor) {
        PlotBuilder subPlot = this.offset(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        subPlot.block("[-1,1] -1 [-1,1]", Blocks.f_50069_);
        subPlot.block("[-1,1] 0 [-1,1]", Blocks.f_50609_);
        subPlot.block("0 0 0", Blocks.f_50016_);
        this.addBuildAction(new SpawnEntityAction(this.bb(PlotBuilder.posToBb(pos)), entity, postProcessor));
    }
}

