/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.security.IActionHost;
import appeng.core.AppEng;
import appeng.helpers.ICustomNameObject;
import appeng.init.InitMenuTypes;
import appeng.menu.AEBaseMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.NetworkHooks;

public final class MenuTypeBuilder<M extends AEBaseMenu, I> {
    @Nullable
    private ResourceLocation id;
    private final Class<I> hostInterface;
    private final MenuFactory<M, I> factory;
    private Function<I, Component> menuTitleStrategy = this::getDefaultMenuTitle;
    @Nullable
    private SecurityPermissions requiredPermission;
    @Nullable
    private InitialDataSerializer<I> initialDataSerializer;
    @Nullable
    private InitialDataDeserializer<M, I> initialDataDeserializer;
    private MenuType<M> menuType;

    private MenuTypeBuilder(Class<I> hostInterface, TypedMenuFactory<M, I> typedFactory) {
        this.hostInterface = hostInterface;
        this.factory = (containerId, playerInv, accessObj) -> (AEBaseMenu)((Object)((Object)typedFactory.create(this.menuType, containerId, playerInv, accessObj)));
    }

    private MenuTypeBuilder(Class<I> hostInterface, MenuFactory<M, I> factory) {
        this.hostInterface = hostInterface;
        this.factory = factory;
    }

    public static <C extends AEBaseMenu, I> MenuTypeBuilder<C, I> create(MenuFactory<C, I> factory, Class<I> hostInterface) {
        return new MenuTypeBuilder<C, I>(hostInterface, factory);
    }

    public static <C extends AEBaseMenu, I> MenuTypeBuilder<C, I> create(TypedMenuFactory<C, I> factory, Class<I> hostInterface) {
        return new MenuTypeBuilder<C, I>(hostInterface, factory);
    }

    public MenuTypeBuilder<M, I> requirePermission(SecurityPermissions permission) {
        this.requiredPermission = permission;
        return this;
    }

    public MenuTypeBuilder<M, I> withMenuTitle(Function<I, Component> menuTitleStrategy) {
        this.menuTitleStrategy = menuTitleStrategy;
        return this;
    }

    public MenuTypeBuilder<M, I> withInitialData(InitialDataSerializer<I> initialDataSerializer, InitialDataDeserializer<M, I> initialDataDeserializer) {
        this.initialDataSerializer = initialDataSerializer;
        this.initialDataDeserializer = initialDataDeserializer;
        return this;
    }

    private M fromNetwork(int containerId, Inventory inv, FriendlyByteBuf packetBuf) {
        MenuLocator locator = MenuLocators.readFromPacket(packetBuf);
        I host = locator.locate(inv.f_35978_, this.hostInterface);
        if (host == null) {
            ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
            if (connection != null) {
                connection.m_104955_((Packet)new ServerboundContainerClosePacket(containerId));
            }
            throw new IllegalStateException("Couldn't find menu host at " + locator + " for " + this.id + " on client. Closing menu.");
        }
        AEBaseMenu menu = (AEBaseMenu)((Object)this.factory.create(containerId, inv, host));
        menu.setReturnedFromSubScreen(packetBuf.readBoolean());
        if (this.initialDataDeserializer != null) {
            this.initialDataDeserializer.deserializeInitialData(host, (M)((Object)menu), packetBuf);
        }
        return (M)((Object)menu);
    }

    private boolean open(Player player, MenuLocator locator, boolean fromSubMenu) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        I accessInterface = locator.locate(player, this.hostInterface);
        if (accessInterface == null) {
            return false;
        }
        if (!this.checkPermission(player, accessInterface)) {
            return false;
        }
        Component title = this.menuTitleStrategy.apply(accessInterface);
        SimpleMenuProvider menu = new SimpleMenuProvider((wnd, p, pl) -> {
            AEBaseMenu m = (AEBaseMenu)((Object)((Object)this.factory.create(wnd, p, accessInterface)));
            m.setLocator(locator);
            return m;
        }, title);
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)menu, buffer -> {
            MenuLocators.writeToPacket(buffer, locator);
            buffer.writeBoolean(fromSubMenu);
            if (this.initialDataSerializer != null) {
                this.initialDataSerializer.serializeInitialData(accessInterface, (FriendlyByteBuf)buffer);
            }
        });
        return true;
    }

    public MenuType<M> build(String id) {
        Preconditions.checkState((this.menuType == null ? 1 : 0) != 0, (Object)"build was already called");
        Preconditions.checkState((this.id == null ? 1 : 0) != 0, (Object)"id should not be set");
        this.id = AppEng.makeId(id);
        this.menuType = IForgeMenuType.create(this::fromNetwork);
        InitMenuTypes.queueRegistration(this.id, this.menuType);
        MenuOpener.addOpener(this.menuType, this::open);
        return this.menuType;
    }

    private boolean checkPermission(Player player, Object accessInterface) {
        if (this.requiredPermission != null && accessInterface instanceof IActionHost) {
            IActionHost actionHost = (IActionHost)accessInterface;
            return Platform.checkPermissions(player, actionHost, this.requiredPermission, false, true);
        }
        return true;
    }

    private Component getDefaultMenuTitle(I accessInterface) {
        ICustomNameObject customNameObject;
        if (accessInterface instanceof ICustomNameObject && (customNameObject = (ICustomNameObject)accessInterface).hasCustomInventoryName()) {
            return customNameObject.getCustomInventoryName();
        }
        return Component.m_237119_();
    }

    @FunctionalInterface
    public static interface TypedMenuFactory<C extends AbstractContainerMenu, I> {
        public C create(MenuType<C> var1, int var2, Inventory var3, I var4);
    }

    @FunctionalInterface
    public static interface MenuFactory<C, I> {
        public C create(int var1, Inventory var2, I var3);
    }

    @FunctionalInterface
    public static interface InitialDataSerializer<I> {
        public void serializeInitialData(I var1, FriendlyByteBuf var2);
    }

    @FunctionalInterface
    public static interface InitialDataDeserializer<C, I> {
        public void deserializeInitialData(I var1, C var2, FriendlyByteBuf var3);
    }
}

