/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.features.Locatables;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.qnb.QuantumBridgeBlockEntity;
import appeng.core.AELog;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.MBCalculator;
import appeng.me.service.helpers.ConnectionWrapper;
import appeng.util.iterators.ChainedIterator;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class QuantumCluster
implements IAECluster,
IActionHost {
    private final BlockPos boundsMin;
    private final BlockPos boundsMax;
    private boolean isDestroyed = false;
    private boolean updateStatus = true;
    private QuantumBridgeBlockEntity[] Ring;
    private boolean registered = false;
    private ConnectionWrapper connection;
    private long thisSide;
    private long otherSide;
    private QuantumBridgeBlockEntity center;

    public QuantumCluster(BlockPos min, BlockPos max) {
        this.boundsMin = min.m_7949_();
        this.boundsMax = max.m_7949_();
        this.setRing(new QuantumBridgeBlockEntity[8]);
    }

    @SubscribeEvent
    public void onUnload(LevelEvent.Unload e) {
        if (this.center.m_58904_() == e.getLevel()) {
            this.setUpdateStatus(false);
            this.destroy();
        }
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        long qe = this.center.getQEFrequency();
        if (this.thisSide != qe && this.thisSide != -qe) {
            if (qe != 0L) {
                if (this.thisSide != 0L) {
                    Locatables.quantumNetworkBridges().unregister(this.center.m_58904_(), this.getLocatableKey());
                }
                if (this.canUseNode(-qe)) {
                    this.otherSide = qe;
                    this.thisSide = -qe;
                } else if (this.canUseNode(qe)) {
                    this.thisSide = qe;
                    this.otherSide = -qe;
                }
                Locatables.quantumNetworkBridges().register(this.center.m_58904_(), this.getLocatableKey(), this);
            } else {
                Locatables.quantumNetworkBridges().unregister(this.center.m_58904_(), this.getLocatableKey());
                this.otherSide = 0L;
                this.thisSide = 0L;
            }
        }
        IActionHost myOtherSide = this.otherSide == 0L ? null : Locatables.quantumNetworkBridges().get(this.center.m_58904_(), this.otherSide);
        boolean shutdown = false;
        if (myOtherSide instanceof QuantumCluster) {
            QuantumCluster sideB = (QuantumCluster)myOtherSide;
            QuantumCluster sideA = this;
            if (sideA.isActive() && sideB.isActive()) {
                if (this.connection != null && this.connection.getConnection() != null) {
                    IGridNode a = this.connection.getConnection().a();
                    IGridNode b = this.connection.getConnection().b();
                    IGridNode sa = sideA.getNode();
                    IGridNode sb = sideB.getNode();
                    if (!(a != sa && b != sa || a != sb && b != sb)) {
                        return;
                    }
                }
                try {
                    if (sideA.connection != null && sideA.connection.getConnection() != null) {
                        sideA.connection.getConnection().destroy();
                        sideA.connection = new ConnectionWrapper(null);
                    }
                    if (sideB.connection != null && sideB.connection.getConnection() != null) {
                        sideB.connection.getConnection().destroy();
                        sideB.connection = new ConnectionWrapper(null);
                    }
                    sideA.connection = sideB.connection = new ConnectionWrapper(GridHelper.createGridConnection(sideA.getNode(), sideB.getNode()));
                }
                catch (FailedConnectionException e) {
                    AELog.debug(e);
                }
            } else {
                shutdown = true;
            }
        } else {
            shutdown = true;
        }
        if (shutdown && this.connection != null && this.connection.getConnection() != null) {
            this.connection.getConnection().destroy();
            this.connection.setConnection(null);
            this.connection = new ConnectionWrapper(null);
        }
    }

    private boolean canUseNode(long qe) {
        IActionHost locatable = Locatables.quantumNetworkBridges().get(this.center.m_58904_(), qe);
        if (locatable instanceof QuantumCluster) {
            QuantumCluster qc = (QuantumCluster)locatable;
            Level level = qc.center.m_58904_();
            if (!qc.isDestroyed) {
                if (level.m_46805_(qc.center.m_58899_())) {
                    ServerLevel cur = level.m_7654_().m_129880_(level.m_46472_());
                    BlockEntity te = level.m_7702_(qc.center.m_58899_());
                    return te != qc.center || level != cur;
                }
                AELog.warn("Found a registered QNB with serial %s whose chunk seems to be unloaded: %s", qe, qc);
            }
        }
        return true;
    }

    private boolean isActive() {
        if (this.isDestroyed || !this.registered) {
            return false;
        }
        return this.center.isPowered() && this.hasQES();
    }

    private IGridNode getNode() {
        return this.center.getGridNode();
    }

    private boolean hasQES() {
        return this.thisSide != 0L;
    }

    @Override
    public BlockPos getBoundsMin() {
        return this.boundsMin;
    }

    @Override
    public BlockPos getBoundsMax() {
        return this.boundsMax;
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        MBCalculator.setModificationInProgress(this);
        try {
            if (this.registered) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                this.registered = false;
            }
            if (this.thisSide != 0L) {
                this.updateStatus(true);
                Locatables.quantumNetworkBridges().unregister(this.center.m_58904_(), this.getLocatableKey());
            }
            this.center.updateStatus(null, (byte)-1, this.isUpdateStatus());
            for (QuantumBridgeBlockEntity r : this.getRing()) {
                r.updateStatus(null, (byte)-1, this.isUpdateStatus());
            }
            this.center = null;
            this.setRing(new QuantumBridgeBlockEntity[8]);
        }
        finally {
            MBCalculator.setModificationInProgress(null);
        }
    }

    public Iterator<QuantumBridgeBlockEntity> getBlockEntities() {
        return new ChainedIterator<QuantumBridgeBlockEntity>(this.getRing()[0], this.getRing()[1], this.getRing()[2], this.getRing()[3], this.getRing()[4], this.getRing()[5], this.getRing()[6], this.getRing()[7], this.center);
    }

    public boolean isCorner(QuantumBridgeBlockEntity quantumBridge) {
        return this.getRing()[0] == quantumBridge || this.getRing()[2] == quantumBridge || this.getRing()[4] == quantumBridge || this.getRing()[6] == quantumBridge;
    }

    private long getLocatableKey() {
        return this.thisSide;
    }

    public QuantumBridgeBlockEntity getCenter() {
        return this.center;
    }

    void setCenter(QuantumBridgeBlockEntity c) {
        this.registered = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.center = c;
    }

    private boolean isUpdateStatus() {
        return this.updateStatus;
    }

    public void setUpdateStatus(boolean updateStatus) {
        this.updateStatus = updateStatus;
    }

    QuantumBridgeBlockEntity[] getRing() {
        return this.Ring;
    }

    private void setRing(QuantumBridgeBlockEntity[] ring) {
        this.Ring = ring;
    }

    public String toString() {
        if (this.center == null) {
            return "QuantumCluster{no-center}";
        }
        Level level = this.center.m_58904_();
        BlockPos pos = this.center.m_58899_();
        return "QuantumCluster{" + level + "," + pos + "}";
    }

    @Override
    @Nullable
    public IGridNode getActionableNode() {
        return this.center.getMainNode().getNode();
    }
}

