/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark.commonmark;

import appeng.libs.micromark.Assert;
import appeng.libs.micromark.CharUtil;
import appeng.libs.micromark.Construct;
import appeng.libs.micromark.State;
import appeng.libs.micromark.Token;
import appeng.libs.micromark.TokenizeContext;
import appeng.libs.micromark.Tokenizer;
import appeng.libs.micromark.commonmark.BlankLine;
import appeng.libs.micromark.commonmark.ThematicBreak;
import appeng.libs.micromark.factory.FactorySpace;

public final class ListConstruct {
    public static final Construct list = new Construct();
    public static final Construct listItemPrefixWhitespaceConstruct;
    public static final Construct indentConstruct;

    private ListConstruct() {
    }

    static {
        ListConstruct.list.name = "list";
        ListConstruct.list.tokenize = (context, effects, ok, nok) -> new StartStateMachine(context, effects, ok, nok)::start;
        ListConstruct.list.continuation = new Construct();
        ListConstruct.list.continuation.tokenize = (context, effects, ok, nok) -> new ContinuationStateMachine((TokenizeContext)context, (Tokenizer.Effects)effects, (State)ok, (State)nok).start;
        ListConstruct.list.exit = (context, effects) -> effects.exit((String)context.getContainerState().get("type"));
        listItemPrefixWhitespaceConstruct = new Construct();
        ListConstruct.listItemPrefixWhitespaceConstruct.tokenize = (context, effects, ok, nok) -> new ItemPrefixWhitespaceStateMachine((TokenizeContext)context, (Tokenizer.Effects)effects, (State)ok, (State)nok).start;
        ListConstruct.listItemPrefixWhitespaceConstruct.partial = true;
        indentConstruct = new Construct();
        ListConstruct.indentConstruct.tokenize = (context, effects, ok, nok) -> new IndentStateMachine((TokenizeContext)context, (Tokenizer.Effects)effects, (State)ok, (State)nok).start;
        ListConstruct.indentConstruct.partial = true;
    }

    private static class IndentStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        public final State start;

        public IndentStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            this.start = FactorySpace.create(effects, this::afterPrefix, "listItemIndent", context.getContainerState().getOrDefault("size", 0) + 1);
        }

        private State afterPrefix(int code) {
            Tokenizer.Event tail = this.context.getLastEvent();
            return tail != null && tail.token().type.equals("listItemIndent") && tail.context().sliceSerialize(tail.token(), true).length() == this.context.getContainerState().getOrDefault("size", 0).intValue() ? this.ok.step(code) : this.nok.step(code);
        }
    }

    private static class ItemPrefixWhitespaceStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        public final State start;

        public ItemPrefixWhitespaceStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            this.start = FactorySpace.create(effects, this::afterPrefix, "listItemPrefixWhitespace", context.getParser().constructs.nullDisable.contains("codeIndented") ? null : Integer.valueOf(5));
        }

        private State afterPrefix(int code) {
            Tokenizer.Event tail = this.context.getLastEvent();
            return !CharUtil.markdownSpace(code) && tail != null && tail.token().type.equals("listItemPrefixWhitespace") ? this.ok.step(code) : this.nok.step(code);
        }
    }

    private static class ContinuationStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        public final State start;

        public ContinuationStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            context.getContainerState().remove("_closeFlow");
            this.start = effects.check.hook(BlankLine.blankLine, this::onBlank, this::notBlank);
        }

        private State onBlank(int code) {
            this.context.getContainerState().putIfAbsent("furtherBlankLines", this.context.getContainerState().getOrDefault("initialBlankLine", false));
            return FactorySpace.create(this.effects, this.ok, "listItemIndent", this.context.getContainerState().getOrDefault("size", 0) + 1).step(code);
        }

        private State notBlank(int code) {
            if (this.context.getContainerState().getOrDefault("furtherBlankLines", false).booleanValue() || !CharUtil.markdownSpace(code)) {
                this.context.getContainerState().remove("furtherBlankLines");
                this.context.getContainerState().remove("initialBlankLine");
                return this.notInCurrentItem(code);
            }
            this.context.getContainerState().remove("furtherBlankLines");
            this.context.getContainerState().remove("initialBlankLine");
            return this.effects.attempt.hook(indentConstruct, this.ok, this::notInCurrentItem).step(code);
        }

        private State notInCurrentItem(int code) {
            this.context.getContainerState().put("_closeFlow", true);
            this.context.setInterrupt(false);
            return FactorySpace.create(this.effects, this.effects.attempt.hook(list, this.ok, this.nok), "linePrefix", this.context.getParser().constructs.nullDisable.contains("codeIndented") ? null : Integer.valueOf(4)).step(code);
        }
    }

    private static class StartStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        private int initialSize;
        private int size;

        public StartStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            Tokenizer.Event tail = context.getLastEvent();
            this.initialSize = tail != null && tail.token().type.equals("linePrefix") ? tail.context().sliceSerialize(tail.token(), true).length() : 0;
        }

        private State start(int code) {
            String kind = this.context.getContainerState().getOrDefault("type", code == 42 || code == 43 || code == 45 ? "listUnordered" : "listOrdered");
            if (kind.equals("listUnordered") ? !this.context.getContainerState().containsKey("marker") || code == (Integer)this.context.getContainerState().get("marker") : CharUtil.asciiDigit(code)) {
                if (!this.context.getContainerState().containsKey("type")) {
                    this.context.getContainerState().put("type", kind);
                    Token tokenFields = new Token();
                    tokenFields._container = true;
                    this.effects.enter(kind, tokenFields);
                }
                if (kind.equals("listUnordered")) {
                    this.effects.enter("listItemPrefix");
                    return code == 42 || code == 45 ? this.effects.check.hook(ThematicBreak.thematicBreak, this.nok, this::atMarker).step(code) : this.atMarker(code);
                }
                if (!this.context.isInterrupt() || code == 49) {
                    this.effects.enter("listItemPrefix");
                    this.effects.enter("listItemValue");
                    return this.inside(code);
                }
            }
            return this.nok.step(code);
        }

        private State inside(int code) {
            if (CharUtil.asciiDigit(code) && ++this.size < 10) {
                this.effects.consume(code);
                return this::inside;
            }
            if ((!this.context.isInterrupt() || this.size < 2) && (this.context.getContainerState().containsKey("marker") ? code == (Integer)this.context.getContainerState().get("marker") : code == 41 || code == 46)) {
                this.effects.exit("listItemValue");
                return this.atMarker(code);
            }
            return this.nok.step(code);
        }

        private State atMarker(int code) {
            Assert.check(code != Integer.MIN_VALUE, "eof (`null`) is not a marker");
            this.effects.enter("listItemMarker");
            this.effects.consume(code);
            this.effects.exit("listItemMarker");
            this.context.getContainerState().putIfAbsent("marker", code);
            return this.effects.check.hook(BlankLine.blankLine, this.context.isInterrupt() ? this.nok : this::onBlank, this.effects.attempt.hook(listItemPrefixWhitespaceConstruct, this::endOfPrefix, this::otherPrefix));
        }

        private State onBlank(int code) {
            this.context.getContainerState().put("initialBlankLine", true);
            ++this.initialSize;
            return this.endOfPrefix(code);
        }

        private State otherPrefix(int code) {
            if (CharUtil.markdownSpace(code)) {
                this.effects.enter("listItemPrefixWhitespace");
                this.effects.consume(code);
                this.effects.exit("listItemPrefixWhitespace");
                return this::endOfPrefix;
            }
            return this.nok.step(code);
        }

        private State endOfPrefix(int code) {
            this.context.getContainerState().put("size", this.initialSize + this.context.sliceSerialize(this.effects.exit("listItemPrefix"), true).length());
            return this.ok.step(code);
        }
    }
}

