/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.stacks.AEItemKey;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BiometricCardItem
extends AEBaseItem
implements IBiometricCard {
    public BiometricCardItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player p, InteractionHand hand) {
        if (InteractionUtil.isInAlternateUseMode(p)) {
            this.encode(p.m_21120_(hand), p);
            p.m_6674_(hand);
            return InteractionResultHolder.m_19090_((Object)p.m_21120_(hand));
        }
        return InteractionResultHolder.m_19098_((Object)p.m_21120_(hand));
    }

    public InteractionResult m_6880_(ItemStack is, Player player, LivingEntity target, InteractionHand hand) {
        if (target instanceof Player && !InteractionUtil.isInAlternateUseMode(player)) {
            if (player.m_7500_()) {
                is = player.m_21120_(hand);
            }
            this.encode(is, (Player)target);
            player.m_6674_(hand);
            return InteractionResult.m_19078_((boolean)player.m_20193_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    public Component m_7626_(ItemStack is) {
        GameProfile profile = this.getProfile(is);
        return profile != null ? super.m_7626_(is).m_6881_().m_130946_(" - " + profile.getName()) : super.m_7626_(is);
    }

    private void encode(ItemStack is, Player p) {
        GameProfile profile = this.getProfile(is);
        if (profile != null && profile.equals((Object)p.m_36316_())) {
            this.setProfile(is, null);
        } else {
            this.setProfile(is, p.m_36316_());
        }
    }

    @Override
    public void setProfile(ItemStack itemStack, GameProfile profile) {
        CompoundTag tag = itemStack.m_41784_();
        if (profile != null) {
            CompoundTag pNBT = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)pNBT, (GameProfile)profile);
            tag.m_128365_("profile", (Tag)pNBT);
        } else {
            tag.m_128473_("profile");
        }
    }

    @Override
    public GameProfile getProfile(ItemStack is) {
        return this.getProfile(is.m_41783_());
    }

    @Nullable
    public GameProfile getProfile(AEItemKey key) {
        return this.getProfile(key.getTag());
    }

    private GameProfile getProfile(@Nullable CompoundTag tag) {
        if (tag != null && tag.m_128441_("profile")) {
            return NbtUtils.m_129228_((CompoundTag)tag.m_128469_("profile"));
        }
        return null;
    }

    @Override
    public EnumSet<SecurityPermissions> getPermissions(ItemStack is) {
        return this.getPermissions(is.m_41783_());
    }

    public EnumSet<SecurityPermissions> getPermissions(@Nullable CompoundTag tag) {
        EnumSet<SecurityPermissions> result = EnumSet.noneOf(SecurityPermissions.class);
        if (tag != null) {
            for (SecurityPermissions sp : SecurityPermissions.values()) {
                if (!tag.m_128471_(sp.name())) continue;
                result.add(sp);
            }
        }
        return result;
    }

    @Override
    public boolean hasPermission(ItemStack is, SecurityPermissions permission) {
        CompoundTag tag = is.m_41784_();
        return tag.m_128471_(permission.name());
    }

    @Override
    public void removePermission(ItemStack itemStack, SecurityPermissions permission) {
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128441_(permission.name())) {
            tag.m_128473_(permission.name());
        }
    }

    @Override
    public void addPermission(ItemStack itemStack, SecurityPermissions permission) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128379_(permission.name(), true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        EnumSet<SecurityPermissions> perms = this.getPermissions(stack);
        if (perms.isEmpty()) {
            lines.add((Component)Tooltips.of(GuiText.NoPermissions, new Object[0]));
        } else {
            Component msg = null;
            for (SecurityPermissions sp : perms) {
                if (msg == null) {
                    msg = sp.getDisplayName();
                    continue;
                }
                msg = msg.m_6881_().m_130946_(", ").m_7220_(sp.getDisplayName());
            }
            lines.add((Component)msg.m_6881_().m_6270_(Tooltips.GREEN));
        }
    }
}

