/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.api.util.AEColor;
import appeng.client.render.BasicUnbakedModel;
import appeng.client.render.model.MemoryCardBakedModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

public class MemoryCardModel
implements BasicUnbakedModel<MemoryCardModel> {
    public static final Map<AEColor, ResourceLocation> MODELS_BASE = new HashMap<AEColor, ResourceLocation>();
    private final AEColor memoryCardColor;
    private static final Material TEXTURE;

    public MemoryCardModel(AEColor memoryCardColor) {
        this.memoryCardColor = memoryCardColor;
    }

    @Override
    public Collection<ResourceLocation> getModelDependencies() {
        return Collections.singleton(MODELS_BASE.get((Object)this.memoryCardColor));
    }

    @Nullable
    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite texture = spriteGetter.apply(TEXTURE);
        BakedModel baseModel = bakery.bake(MODELS_BASE.get((Object)this.memoryCardColor), modelTransform, spriteGetter);
        return new MemoryCardBakedModel(baseModel, texture);
    }

    @Override
    public Stream<Material> getAdditionalTextures() {
        return Stream.of(TEXTURE);
    }

    static {
        for (AEColor color : AEColor.values()) {
            if (color != AEColor.TRANSPARENT) {
                MODELS_BASE.put(color, new ResourceLocation("ae2", "item/memory_card_" + color.registryPrefix + "_base"));
                continue;
            }
            MODELS_BASE.put(color, new ResourceLocation("ae2", "item/memory_card_base"));
        }
        TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("ae2", "item/memory_card_hash"));
    }
}

