/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.screen;

import appeng.client.Point;
import appeng.client.gui.DashPattern;
import appeng.client.gui.DashedRectangle;
import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.PageCollection;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytDocument;
import appeng.client.guidebook.document.block.LytHeading;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.block.LytParagraph;
import appeng.client.guidebook.document.flow.LytFlowContainer;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.interaction.GuideTooltip;
import appeng.client.guidebook.document.interaction.InteractiveElement;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.MinecraftFontMetrics;
import appeng.client.guidebook.render.ColorRef;
import appeng.client.guidebook.render.GuidePageTexture;
import appeng.client.guidebook.render.LightDarkMode;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.client.guidebook.screen.GuideNavBar;
import appeng.client.guidebook.screen.GuideScrollbar;
import appeng.client.guidebook.screen.TooltipFrame;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GuideScreen
extends Screen {
    private static final int HISTORY_SIZE = 100;
    private static final List<PageAnchor> history = new ArrayList<PageAnchor>();
    private static int historyPosition;
    private static final DashPattern DEBUG_NODE_OUTLINE;
    private static final DashPattern DEBUG_CONTENT_OUTLINE;
    private final PageCollection pages;
    private final GuideScrollbar scrollbar;
    private GuidePage currentPage;
    private Button backButton;
    private Button forwardButton;

    private GuideScreen(PageCollection pages, PageAnchor anchor) {
        super((Component)Component.m_237113_((String)"AE2 Guidebook"));
        this.pages = pages;
        this.scrollbar = new GuideScrollbar();
        this.loadPage(anchor);
    }

    public static GuideScreen openNew(PageCollection pages, PageAnchor anchor) {
        if (history.lastIndexOf(anchor) != history.size()) {
            historyPosition = history.size();
            history.add(anchor);
        }
        return new GuideScreen(pages, anchor);
    }

    public static GuideScreen openAtPreviousPage(PageCollection pages, PageAnchor anchor) {
        if (historyPosition >= history.size()) {
            return GuideScreen.openNew(pages, anchor);
        }
        anchor = history.get(historyPosition);
        return new GuideScreen(pages, anchor);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updatePageLayout();
        LytRect docRect = this.getDocumentRect();
        this.m_142416_((GuiEventListener)this.scrollbar);
        this.scrollbar.move(docRect.right(), docRect.y(), docRect.height());
        GuideNavBar navbar = new GuideNavBar(this);
        this.m_142416_((GuiEventListener)navbar);
        this.backButton = new Button(docRect.right() - 40, docRect.y() - 15, 20, 15, (Component)Component.m_237113_((String)"<"), button -> this.navigateBack());
        this.m_142416_((GuiEventListener)this.backButton);
        this.forwardButton = new Button(docRect.right() - 20, docRect.y() - 15, 20, 15, (Component)Component.m_237113_((String)">"), button -> this.navigateForward());
        this.m_142416_((GuiEventListener)this.forwardButton);
        this.updateNavigationButtons();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.updateNavigationButtons();
        this.m_7333_(poseStack);
        LytRect documentRect = this.getDocumentRect();
        GuideScreen.m_93172_((PoseStack)poseStack, (int)documentRect.x(), (int)documentRect.y(), (int)documentRect.right(), (int)documentRect.bottom(), (int)-2144128205);
        LytRect documentViewport = this.getDocumentViewport();
        poseStack.m_85836_();
        poseStack.m_85837_((double)(documentRect.x() - documentViewport.x()), (double)(documentRect.y() - documentViewport.y()), 0.0);
        LytDocument document = this.currentPage.getDocument();
        SimpleRenderContext context = new SimpleRenderContext(documentViewport, poseStack, LightDarkMode.LIGHT_MODE);
        GuideScreen.m_239260_((int)documentRect.x(), (int)documentRect.y(), (int)documentRect.right(), (int)documentRect.bottom());
        MultiBufferSource.BufferSource buffers = context.beginBatch();
        document.renderBatch(context, (MultiBufferSource)buffers);
        context.endBatch(buffers);
        document.render(context);
        GuideScreen.m_240060_();
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 100.0);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        poseStack.m_85849_();
        if (document.getHoveredElement() != null) {
            this.renderTooltip(poseStack, mouseX, mouseY);
        }
    }

    private void renderTooltip(PoseStack poseStack, int x, int y) {
        Point docPos = this.getDocumentPoint(x, y);
        if (docPos == null) {
            return;
        }
        GuideTooltip tooltip = this.dispatchInteraction(docPos.getX(), docPos.getY(), InteractiveElement::getTooltip).orElse(null);
        if (tooltip != null) {
            this.renderTooltip(poseStack, tooltip, x, y);
        }
    }

    private static void renderHoverOutline(LytDocument document, SimpleRenderContext context) {
        LytDocument.HitTestResult hoveredElement = document.getHoveredElement();
        if (hoveredElement != null) {
            LytNode lytNode = hoveredElement.node();
            if (lytNode instanceof LytBlock) {
                LytBlock block = (LytBlock)lytNode;
                LytRect bounds = block.getBounds();
                if (block.getMarginTop() > 0) {
                    context.fillRect(bounds.withHeight(block.getMarginTop()).move(0, -block.getMarginTop()), new ColorRef(0x7FFFFF00));
                }
                if (block.getMarginBottom() > 0) {
                    context.fillRect(bounds.withHeight(block.getMarginBottom()).move(0, bounds.height()), new ColorRef(0x7FFFFF00));
                }
                if (block.getMarginLeft() > 0) {
                    context.fillRect(bounds.withWidth(block.getMarginLeft()).move(-block.getMarginLeft(), 0), new ColorRef(0x7FFFFF00));
                }
                if (block.getMarginRight() > 0) {
                    context.fillRect(bounds.withWidth(block.getMarginRight()).move(bounds.width(), 0), new ColorRef(0x7FFFFF00));
                }
            }
            DashedRectangle.render(context.poseStack(), hoveredElement.node().getBounds(), DEBUG_NODE_OUTLINE, 0.0f);
            if (hoveredElement.content() != null && (lytNode = hoveredElement.node()) instanceof LytFlowContainer) {
                LytFlowContainer flowContainer = (LytFlowContainer)((Object)lytNode);
                flowContainer.enumerateContentBounds(hoveredElement.content()).forEach(bound -> DashedRectangle.render(context.poseStack(), bound, DEBUG_CONTENT_OUTLINE, 0.0f));
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        Point docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            if (button == 3) {
                this.navigateBack();
            } else if (button == 4) {
                this.navigateForward();
            }
            return this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseClicked(this, docPoint.getX(), docPoint.getY(), button));
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (super.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        Point docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            return this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseReleased(this, docPoint.getX(), docPoint.getY(), button));
        }
        return false;
    }

    public void navigateTo(ResourceLocation pageId) {
        this.navigateTo(new PageAnchor(pageId, null));
    }

    public void navigateTo(PageAnchor anchor) {
        if (this.currentPage.getId().equals((Object)anchor.pageId())) {
            return;
        }
        this.loadPage(anchor);
        if (historyPosition + 1 < history.size()) {
            history.subList(historyPosition + 1, history.size()).clear();
        }
        if (history.size() >= 100) {
            history.subList(0, history.size() - 100).clear();
        }
        historyPosition = history.size();
        history.add(anchor);
    }

    private void navigateForward() {
        if (historyPosition + 1 < history.size()) {
            this.loadPage(history.get(++historyPosition));
        }
    }

    private void navigateBack() {
        if (historyPosition > 0) {
            this.loadPage(history.get(--historyPosition));
        }
    }

    private void loadPage(PageAnchor anchor) {
        GuidePageTexture.releaseUsedTextures();
        this.currentPage = this.pages.getPage(anchor.pageId());
        if (this.currentPage == null) {
            this.currentPage = this.buildNotFoundPage(anchor);
        }
        this.scrollbar.setScrollAmount(0);
        this.updatePageLayout();
    }

    private GuidePage buildNotFoundPage(PageAnchor anchor) {
        LytDocument document = new LytDocument();
        LytHeading title = new LytHeading();
        title.appendText("Page not Found");
        title.setDepth(1);
        document.append(title);
        LytParagraph body = new LytParagraph();
        body.appendText("Page " + anchor.pageId() + " could not be found.");
        document.append(body);
        return new GuidePage("ae2", anchor.pageId(), document);
    }

    public void m_7861_() {
        super.m_7861_();
        GuidePageTexture.releaseUsedTextures();
    }

    public void reloadPage() {
        GuidePageTexture.releaseUsedTextures();
        this.currentPage = this.pages.getPage(this.currentPage.getId());
        this.updatePageLayout();
    }

    private boolean dispatchEvent(int x, int y, EventInvoker invoker) {
        return this.dispatchInteraction(x, y, el -> {
            if (invoker.invoke((InteractiveElement)el)) {
                return Optional.of(true);
            }
            return Optional.empty();
        }).orElse(false);
    }

    private <T> Optional<T> dispatchInteraction(int x, int y, Function<InteractiveElement, Optional<T>> invoker) {
        LytDocument.HitTestResult underCursor = this.currentPage.getDocument().pick(x, y);
        if (underCursor != null) {
            InteractiveElement interactiveEl;
            Optional<T> result;
            for (LytFlowContent el = underCursor.content(); el != null; el = el.getFlowParent()) {
                if (!(el instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)el))).isPresent()) continue;
                return result;
            }
            for (LytNode node = underCursor.node(); node != null; node = node.getParent()) {
                if (!(node instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)node))).isPresent()) continue;
                return result;
            }
        }
        return Optional.empty();
    }

    public void m_169414_() {
        super.m_169414_();
        LytDocument document = this.currentPage.getDocument();
        MouseHandler mouseHandler = this.f_96541_.f_91067_;
        double scale = (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_();
        double x = mouseHandler.m_91589_() * scale;
        double y = mouseHandler.m_91594_() * scale;
        if (this.m_94729_(x, y).isPresent()) {
            document.setHoveredElement(null);
            return;
        }
        Point docPoint = this.getDocumentPoint(x, y);
        if (docPoint != null) {
            LytDocument.HitTestResult hoveredEl = document.pick(docPoint.getX(), docPoint.getY());
            document.setHoveredElement(hoveredEl);
        } else {
            document.setHoveredElement(null);
        }
    }

    @Nullable
    private Point getDocumentPoint(double screenX, double screenY) {
        LytRect documentRect = this.getDocumentRect();
        if (screenX >= (double)documentRect.x() && screenX < (double)documentRect.right() && screenY >= (double)documentRect.y() && screenY < (double)documentRect.bottom()) {
            int docX = (int)Math.round(screenX - (double)documentRect.x());
            int docY = (int)Math.round(screenY + (double)this.scrollbar.getScrollAmount() - (double)documentRect.y());
            return new Point(docX, docY);
        }
        return null;
    }

    private LytRect getDocumentRect() {
        int margin = 20;
        return new LytRect(margin, margin, this.f_96543_ - 2 * margin, this.f_96544_ - 2 * margin);
    }

    private LytRect getDocumentViewport() {
        LytRect documentRect = this.getDocumentRect();
        return new LytRect(0, this.scrollbar.getScrollAmount(), documentRect.width(), documentRect.height());
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!super.m_6050_(mouseX, mouseY, delta)) {
            return this.scrollbar.m_6050_(mouseX, mouseY, delta);
        }
        return true;
    }

    private void renderTooltip(PoseStack poseStack, GuideTooltip tooltip, int mouseX, int mouseY) {
        ClientTooltipComponent line;
        int i;
        Minecraft minecraft = Minecraft.m_91087_();
        List<ClientTooltipComponent> clientLines = tooltip.getLines(this);
        if (clientLines.isEmpty()) {
            return;
        }
        int frameWidth = 0;
        int frameHeight = clientLines.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent clientTooltipComponent : clientLines) {
            frameWidth = Math.max(frameWidth, clientTooltipComponent.m_142069_(minecraft.f_91062_));
            frameHeight += clientTooltipComponent.m_142103_();
        }
        if (!tooltip.getIcon().m_41619_()) {
            frameWidth += 18;
            frameHeight = Math.max(frameHeight, 18);
        }
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + frameWidth > this.f_96543_) {
            x -= 28 + frameWidth;
        }
        if (y + frameHeight + 6 > this.f_96544_) {
            y = this.f_96544_ - frameHeight - 6;
        }
        int zOffset = 400;
        TooltipFrame.render(poseStack, x, y, frameWidth, frameHeight, zOffset);
        float prevZOffset = this.f_96542_.f_115093_;
        this.f_96542_.f_115093_ = zOffset;
        if (!tooltip.getIcon().m_41619_()) {
            x += 18;
        }
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)zOffset);
        int currentY = y;
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.m_142440_(minecraft.f_91062_, x, currentY, poseStack.m_85850_().m_85861_(), bufferSource);
            currentY += line.m_142103_() + (i == 0 ? 2 : 0);
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
        currentY = y;
        if (!tooltip.getIcon().m_41619_()) {
            this.f_96542_.m_115123_(tooltip.getIcon(), x - 18, y);
        }
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.m_183452_(minecraft.f_91062_, x, currentY, poseStack, this.f_96542_, zOffset);
            currentY += line.m_142103_() + (i == 0 ? 2 : 0);
        }
        this.f_96542_.f_115093_ = prevZOffset;
    }

    private void updatePageLayout() {
        LytRect docViewport = this.getDocumentViewport();
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics(), docViewport);
        LytDocument document = this.currentPage.getDocument();
        document.updateLayout(context, docViewport.width());
        this.scrollbar.setContentHeight(document.getContentHeight());
    }

    public ResourceLocation getCurrentPageId() {
        return this.currentPage.getId();
    }

    private void updateNavigationButtons() {
        this.backButton.f_93623_ = historyPosition > 0;
        this.forwardButton.f_93623_ = historyPosition + 1 < history.size();
    }

    public PageCollection getPages() {
        return this.pages;
    }

    static {
        DEBUG_NODE_OUTLINE = new DashPattern(1.0f, 4.0f, 3.0f, -1, 500.0f);
        DEBUG_CONTENT_OUTLINE = new DashPattern(0.5f, 2.0f, 1.0f, Integer.MAX_VALUE, 500.0f);
    }

    @FunctionalInterface
    static interface EventInvoker {
        public boolean invoke(InteractiveElement var1);
    }
}

