/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.layout;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.layout.LayoutContext;
import java.util.List;

public final class Layouts {
    private Layouts() {
    }

    public static LytRect verticalLayout(LayoutContext context, List<LytBlock> children, int x, int y, int availableWidth, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        int innerX = x + paddingLeft;
        int innerY = y + paddingTop;
        int innerWidth = availableWidth - paddingLeft - paddingRight;
        LytBlock previousBlock = null;
        int contentHeight = paddingTop;
        for (LytBlock child : children) {
            innerY = previousBlock != null && previousBlock.getMarginBottom() > 0 ? (innerY += Math.max(previousBlock.getMarginBottom(), child.getMarginTop()) - previousBlock.getMarginBottom()) : (innerY += child.getMarginTop());
            int blockWidth = Math.max(1, innerWidth - child.getMarginLeft() - child.getMarginRight());
            LytRect childBounds = child.layout(context, innerX + child.getMarginLeft(), innerY, blockWidth);
            innerY += childBounds.height() + child.getMarginBottom();
            contentHeight = Math.max(contentHeight, childBounds.bottom() - y);
            previousBlock = child;
        }
        return new LytRect(x, y, availableWidth, contentHeight + paddingBottom);
    }
}

