/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.search;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.menu.me.common.GridInventoryEntry;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.tags.TagKey;

public class TagPredicate
implements Predicate<GridInventoryEntry> {
    private final Pattern searchPattern;
    private final Map<AEKeyType, List<TagKey<?>>> tagCache = new IdentityHashMap();

    public TagPredicate(Pattern searchPattern) {
        this.searchPattern = searchPattern;
    }

    private List<TagKey<?>> buildTagCache(AEKeyType keyType) {
        return keyType.getTagNames().filter(tagKey -> this.searchPattern.matcher(tagKey.f_203868_().toString()).find()).toList();
    }

    @Override
    public boolean test(GridInventoryEntry entry) {
        AEKey what = Objects.requireNonNull(entry.getWhat());
        List tags = this.tagCache.computeIfAbsent(what.getType(), this::buildTagCache);
        for (TagKey tag : tags) {
            if (!what.isTagged(tag)) continue;
            return true;
        }
        return false;
    }
}

