/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.stacks.GenericStack;
import appeng.api.util.AEColor;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.blockentity.crafting.CraftingMonitorModelData;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class CraftingMonitorBlockEntity
extends CraftingBlockEntity
implements IColorableBlockEntity {
    private GenericStack display;
    private AEColor paintedColor = AEColor.TRANSPARENT;

    public CraftingMonitorBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        this.display = GenericStack.readBuffer(data);
        return oldPaintedColor != this.paintedColor || c;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeByte(this.paintedColor.ordinal());
        GenericStack.writeBuffer(this.display, data);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        if (data.m_128441_("paintedColor")) {
            this.paintedColor = AEColor.values()[data.m_128445_("paintedColor")];
        }
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128344_("paintedColor", (byte)this.paintedColor.ordinal());
    }

    public void setJob(@Nullable GenericStack stack) {
        if (!Objects.equals(this.display, stack)) {
            this.display = stack;
            this.markForUpdate();
        }
    }

    @Nullable
    public GenericStack getJobProgress() {
        return this.display;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor newPaintedColor, Player who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    @Override
    public ModelData getModelData() {
        return CraftingMonitorModelData.create(this.getUp(), this.getForward(), this.getConnections(), this.getColor());
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }
}

