/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.features;

import appeng.api.features.PlayerRegistryInternal;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public interface IPlayerRegistry {
    public static IPlayerRegistry getMapping(MinecraftServer server) {
        return PlayerRegistryInternal.get(server);
    }

    @Nullable
    public static IPlayerRegistry getMapping(Level level) {
        if (!level.m_5776_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return IPlayerRegistry.getMapping(serverLevel.m_7654_());
        }
        return null;
    }

    public static int getPlayerId(ServerPlayer player) {
        return IPlayerRegistry.getMapping(player.m_20194_()).getPlayerId(player.m_36316_());
    }

    @Nullable
    public static ServerPlayer getConnected(MinecraftServer server, int playerId) {
        UUID uuid = IPlayerRegistry.getMapping(server).getProfileId(playerId);
        if (uuid == null) {
            return null;
        }
        return server.m_6846_().m_11259_(uuid);
    }

    default public int getPlayerId(GameProfile gameProfile) {
        UUID profileId = gameProfile.getId();
        if (profileId == null) {
            return -1;
        }
        return this.getPlayerId(profileId);
    }

    public int getPlayerId(UUID var1);

    @Nullable
    public UUID getProfileId(int var1);
}

