/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.client;

import appeng.api.client.IAEStackRenderHandler;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ThreadSafe
public class AEStackRendering {
    private static volatile Map<AEKeyType, IAEStackRenderHandler<?>> renderers = new IdentityHashMap();

    public static synchronized <T extends AEKey> void register(AEKeyType channel, Class<T> keyClass, IAEStackRenderHandler<T> handler) {
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(handler, "handler");
        Objects.requireNonNull(keyClass, "keyClass");
        Preconditions.checkArgument((channel.getKeyClass() == keyClass ? 1 : 0) != 0, (String)"%s != %s", channel.getKeyClass(), keyClass);
        IdentityHashMap renderersCopy = new IdentityHashMap(renderers);
        if (renderersCopy.put(channel, handler) != null) {
            throw new IllegalArgumentException("Duplicate registration of render handler for channel " + channel);
        }
        renderers = renderersCopy;
    }

    @Nullable
    public static IAEStackRenderHandler<?> get(AEKeyType channel) {
        return renderers.get(channel);
    }

    public static IAEStackRenderHandler<?> getOrThrow(AEKeyType channel) {
        IAEStackRenderHandler<?> renderHandler = AEStackRendering.get(channel);
        if (renderHandler == null) {
            throw new IllegalArgumentException("Missing render handler for channel " + channel);
        }
        return renderHandler;
    }

    private static IAEStackRenderHandler getUnchecked(AEKey stack) {
        return AEStackRendering.getOrThrow(stack.getType());
    }

    public static void drawInGui(Minecraft minecraft, PoseStack poseStack, int x, int y, int z, AEKey what) {
        AEStackRendering.getUnchecked(what).drawInGui(minecraft, poseStack, x, y, z, what);
    }

    public static void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, AEKey what, float scale, int combinedLightIn) {
        AEStackRendering.getUnchecked(what).drawOnBlockFace(poseStack, buffers, what, scale, combinedLightIn);
    }

    public static Component getDisplayName(AEKey stack) {
        return AEStackRendering.getUnchecked(stack).getDisplayName(stack);
    }

    public static List<Component> getTooltip(AEKey stack) {
        return new ArrayList<Component>(AEStackRendering.getUnchecked(stack).getTooltip(stack));
    }
}

