/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.Defaults;
import com.almostreliable.unified.utils.JsonUtils;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class UnifyConfig
extends Config {
    public static final String NAME = "unify";
    private final List<String> modPriorities;
    private final List<String> stoneStrata;
    private final List<String> unbakedTags;
    private final List<String> materials;
    private final Map<ResourceLocation, String> priorityOverrides;
    private final Map<ResourceLocation, Set<ResourceLocation>> customTags;
    private final Map<ResourceLocation, Set<ResourceLocation>> tagOwnerships;
    private final Enum<TagInheritanceMode> itemTagInheritanceMode;
    private final Map<ResourceLocation, Set<Pattern>> itemTagInheritance;
    private final Enum<TagInheritanceMode> blockTagInheritanceMode;
    private final Map<ResourceLocation, Set<Pattern>> blockTagInheritance;
    private final Set<UnifyTag<Item>> ignoredTags;
    private final Set<Pattern> ignoredItems;
    private final Set<Pattern> ignoredRecipeTypes;
    private final Set<Pattern> ignoredRecipes;
    private final boolean hideJeiRei;
    private final Map<ResourceLocation, Boolean> ignoredRecipeTypesCache;
    @Nullable
    private Set<UnifyTag<Item>> bakedTagsCache;

    public UnifyConfig(List<String> modPriorities, List<String> stoneStrata, List<String> unbakedTags, List<String> materials, Map<ResourceLocation, String> priorityOverrides, Map<ResourceLocation, Set<ResourceLocation>> customTags, Map<ResourceLocation, Set<ResourceLocation>> tagOwnerships, Enum<TagInheritanceMode> itemTagInheritanceMode, Map<ResourceLocation, Set<Pattern>> itemTagInheritance, Enum<TagInheritanceMode> blockTagInheritanceMode, Map<ResourceLocation, Set<Pattern>> blockTagInheritance, Set<UnifyTag<Item>> ignoredTags, Set<Pattern> ignoredItems, Set<Pattern> ignoredRecipeTypes, Set<Pattern> ignoredRecipes, boolean hideJeiRei) {
        this.modPriorities = modPriorities;
        this.stoneStrata = stoneStrata;
        this.unbakedTags = unbakedTags;
        this.materials = materials;
        this.priorityOverrides = priorityOverrides;
        this.customTags = customTags;
        this.tagOwnerships = tagOwnerships;
        this.itemTagInheritanceMode = itemTagInheritanceMode;
        this.itemTagInheritance = itemTagInheritance;
        this.blockTagInheritanceMode = blockTagInheritanceMode;
        this.blockTagInheritance = blockTagInheritance;
        this.ignoredTags = ignoredTags;
        this.ignoredItems = ignoredItems;
        this.ignoredRecipeTypes = ignoredRecipeTypes;
        this.ignoredRecipes = ignoredRecipes;
        this.hideJeiRei = hideJeiRei;
        this.ignoredRecipeTypesCache = new HashMap<ResourceLocation, Boolean>();
    }

    public List<String> getModPriorities() {
        return Collections.unmodifiableList(this.modPriorities);
    }

    public List<String> getStoneStrata() {
        return Collections.unmodifiableList(this.stoneStrata);
    }

    public Set<UnifyTag<Item>> bakeTags() {
        return this.bakeTags($ -> true);
    }

    public Set<UnifyTag<Item>> bakeAndValidateTags(Map<ResourceLocation, Collection<Holder<Item>>> tags) {
        return this.bakeTags(tags::containsKey);
    }

    private Set<UnifyTag<Item>> bakeTags(Predicate<ResourceLocation> tagValidator) {
        if (this.bakedTagsCache != null) {
            return this.bakedTagsCache;
        }
        HashSet<UnifyTag<Item>> result = new HashSet<UnifyTag<Item>>();
        HashSet<UnifyTag<Item>> wrongTags = new HashSet<UnifyTag<Item>>();
        for (String tag : this.unbakedTags) {
            for (String material : this.materials) {
                String replace = tag.replace("{material}", material);
                ResourceLocation asRL = ResourceLocation.m_135820_((String)replace);
                if (asRL == null) {
                    AlmostUnified.LOG.warn("Could not bake tag <{}> with material <{}>", (Object)tag, (Object)material);
                    continue;
                }
                UnifyTag<Item> t = UnifyTag.item(asRL);
                if (this.ignoredTags.contains(t)) continue;
                if (!tagValidator.test(asRL)) {
                    wrongTags.add(t);
                    continue;
                }
                result.add(t);
            }
        }
        if (!wrongTags.isEmpty()) {
            AlmostUnified.LOG.warn("The following tags are invalid and will be ignored: {}", wrongTags.stream().map(UnifyTag::location).collect(Collectors.toList()));
        }
        this.bakedTagsCache = result;
        return result;
    }

    public List<String> getMaterials() {
        return Collections.unmodifiableList(this.materials);
    }

    public Map<ResourceLocation, String> getPriorityOverrides() {
        return Collections.unmodifiableMap(this.priorityOverrides);
    }

    public Map<ResourceLocation, Set<ResourceLocation>> getCustomTags() {
        return Collections.unmodifiableMap(this.customTags);
    }

    public Map<ResourceLocation, Set<ResourceLocation>> getTagOwnerships() {
        return Collections.unmodifiableMap(this.tagOwnerships);
    }

    public boolean shouldInheritItemTag(UnifyTag<Item> itemTag, Set<UnifyTag<Item>> dominantTags) {
        Set<Pattern> patterns = this.itemTagInheritance.get(itemTag.location());
        boolean result = UnifyConfig.checkPatterns(dominantTags, patterns);
        return this.itemTagInheritanceMode == TagInheritanceMode.ALLOW ? result : !result;
    }

    public boolean shouldInheritBlockTag(UnifyTag<Block> itemTag, Set<UnifyTag<Item>> dominantTags) {
        Set<Pattern> patterns = this.blockTagInheritance.get(itemTag.location());
        boolean result = UnifyConfig.checkPatterns(dominantTags, patterns);
        return this.blockTagInheritanceMode == TagInheritanceMode.ALLOW ? result : !result;
    }

    private static <T> boolean checkPatterns(Set<UnifyTag<T>> dominantTags, @Nullable Set<Pattern> patterns) {
        if (patterns == null) {
            return false;
        }
        for (Pattern pattern : patterns) {
            for (UnifyTag<T> dominantTag : dominantTags) {
                if (!pattern.matcher(dominantTag.location().toString()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean includeItem(ResourceLocation item) {
        for (Pattern pattern : this.ignoredItems) {
            if (!pattern.matcher(item.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean includeRecipe(ResourceLocation recipe) {
        for (Pattern pattern : this.ignoredRecipes) {
            if (!pattern.matcher(recipe.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean includeRecipeType(ResourceLocation type) {
        return this.ignoredRecipeTypesCache.computeIfAbsent(type, t -> {
            for (Pattern pattern : this.ignoredRecipeTypes) {
                if (!pattern.matcher(t.toString()).matches()) continue;
                return false;
            }
            return true;
        });
    }

    public boolean reiOrJeiDisabled() {
        return !this.hideJeiRei;
    }

    public void clearCache() {
        this.ignoredRecipeTypesCache.clear();
    }

    public static enum TagInheritanceMode {
        ALLOW,
        DENY;

    }

    public static class Serializer
    extends Config.Serializer<UnifyConfig> {
        public static final String MOD_PRIORITIES = "modPriorities";
        public static final String STONE_STRATA = "stoneStrata";
        public static final String TAGS = "tags";
        public static final String MATERIALS = "materials";
        public static final String PRIORITY_OVERRIDES = "priorityOverrides";
        public static final String CUSTOM_TAGS = "customTags";
        public static final String TAG_OWNERSHIPS = "tagOwnerships";
        public static final String ITEM_TAG_INHERITANCE_MODE = "itemTagInheritanceMode";
        public static final String ITEM_TAG_INHERITANCE = "itemTagInheritance";
        public static final String BLOCK_TAG_INHERITANCE_MODE = "blockTagInheritanceMode";
        public static final String BLOCK_TAG_INHERITANCE = "blockTagInheritance";
        public static final String IGNORED_TAGS = "ignoredTags";
        public static final String IGNORED_ITEMS = "ignoredItems";
        public static final String IGNORED_RECIPE_TYPES = "ignoredRecipeTypes";
        public static final String IGNORED_RECIPES = "ignoredRecipes";
        public static final String HIDE_JEI_REI = "itemsHidingJeiRei";

        @Override
        public UnifyConfig deserialize(JsonObject json) {
            AlmostUnifiedPlatform.Platform platform = AlmostUnifiedPlatform.INSTANCE.getPlatform();
            List<String> modPriorities = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(MOD_PRIORITIES)), Defaults.getModPriorities(platform));
            List<String> stoneStrata = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(STONE_STRATA)), Defaults.STONE_STRATA);
            List<String> tags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(TAGS)), Defaults.getTags(platform));
            List<String> materials = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(MATERIALS)), Defaults.MATERIALS);
            Map priorityOverrides = this.safeGet(() -> JsonUtils.deserializeMap(json, PRIORITY_OVERRIDES, e -> new ResourceLocation((String)e.getKey()), e -> ((JsonElement)e.getValue()).getAsString()), new HashMap());
            Map customTags = this.safeGet(() -> JsonUtils.deserializeMapSet(json, CUSTOM_TAGS, e -> new ResourceLocation((String)e.getKey()), ResourceLocation::new), new HashMap());
            Map tagOwnerships = this.safeGet(() -> JsonUtils.deserializeMapSet(json, TAG_OWNERSHIPS, e -> new ResourceLocation((String)e.getKey()), ResourceLocation::new), new HashMap());
            TagInheritanceMode itemTagInheritanceMode = this.deserializeTagInheritanceMode(json, ITEM_TAG_INHERITANCE_MODE);
            Map<ResourceLocation, Set<Pattern>> itemTagInheritance = this.deserializePatternsForLocations(json, ITEM_TAG_INHERITANCE);
            TagInheritanceMode blockTagInheritanceMode = this.deserializeTagInheritanceMode(json, BLOCK_TAG_INHERITANCE_MODE);
            Map<ResourceLocation, Set<Pattern>> blockTagInheritance = this.deserializePatternsForLocations(json, BLOCK_TAG_INHERITANCE);
            Set ignoredTags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(IGNORED_TAGS)).stream().map(s -> UnifyTag.item(new ResourceLocation(s))).collect(Collectors.toSet()), new HashSet());
            Set<Pattern> ignoredItems = this.deserializePatterns(json, IGNORED_ITEMS, List.of());
            Set<Pattern> ignoredRecipeTypes = this.deserializePatterns(json, IGNORED_RECIPE_TYPES, Defaults.getIgnoredRecipeTypes(platform));
            Set<Pattern> ignoredRecipes = this.deserializePatterns(json, IGNORED_RECIPES, List.of());
            boolean hideJeiRei = this.safeGet(() -> json.getAsJsonPrimitive(HIDE_JEI_REI).getAsBoolean(), true);
            return new UnifyConfig(modPriorities, stoneStrata, tags, materials, priorityOverrides, customTags, tagOwnerships, itemTagInheritanceMode, itemTagInheritance, blockTagInheritanceMode, blockTagInheritance, ignoredTags, ignoredItems, ignoredRecipeTypes, ignoredRecipes, hideJeiRei);
        }

        private TagInheritanceMode deserializeTagInheritanceMode(JsonObject json, String key) {
            return this.safeGet(() -> TagInheritanceMode.valueOf(json.getAsJsonPrimitive(key).getAsString().toUpperCase()), TagInheritanceMode.ALLOW);
        }

        private Map<ResourceLocation, Set<Pattern>> unsafeDeserializePatternsForLocations(JsonObject rawConfigJson, String baseKey) {
            return JsonUtils.deserializeMapSet(rawConfigJson, baseKey, e -> new ResourceLocation((String)e.getKey()), Pattern::compile);
        }

        private Map<ResourceLocation, Set<Pattern>> deserializePatternsForLocations(JsonObject rawConfigJson, String baseKey) {
            return this.safeGet(() -> this.unsafeDeserializePatternsForLocations(rawConfigJson, baseKey), new HashMap());
        }

        @Override
        public JsonObject serialize(UnifyConfig config) {
            JsonObject json = new JsonObject();
            json.add(MOD_PRIORITIES, (JsonElement)JsonUtils.toArray(config.modPriorities));
            json.add(STONE_STRATA, (JsonElement)JsonUtils.toArray(config.stoneStrata));
            json.add(TAGS, (JsonElement)JsonUtils.toArray(config.unbakedTags));
            json.add(MATERIALS, (JsonElement)JsonUtils.toArray(config.materials));
            JsonObject priorityOverrides = new JsonObject();
            config.priorityOverrides.forEach((tag, mod) -> priorityOverrides.addProperty(tag.toString(), mod));
            json.add(PRIORITY_OVERRIDES, (JsonElement)priorityOverrides);
            JsonObject customTags = new JsonObject();
            config.customTags.forEach((parent, child) -> customTags.add(parent.toString(), (JsonElement)JsonUtils.toArray(child.stream().map(ResourceLocation::toString).toList())));
            json.add(CUSTOM_TAGS, (JsonElement)customTags);
            JsonObject tagOwnerships = new JsonObject();
            config.tagOwnerships.forEach((parent, child) -> tagOwnerships.add(parent.toString(), (JsonElement)JsonUtils.toArray(child.stream().map(ResourceLocation::toString).toList())));
            json.add(TAG_OWNERSHIPS, (JsonElement)tagOwnerships);
            JsonObject itemTagInheritance = new JsonObject();
            config.itemTagInheritance.forEach((tag, patterns) -> itemTagInheritance.add(tag.toString(), (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::toString).toList())));
            json.add(ITEM_TAG_INHERITANCE_MODE, (JsonElement)new JsonPrimitive(config.itemTagInheritanceMode.toString()));
            json.add(ITEM_TAG_INHERITANCE, (JsonElement)itemTagInheritance);
            JsonObject blockTagInheritance = new JsonObject();
            config.blockTagInheritance.forEach((tag, patterns) -> blockTagInheritance.add(tag.toString(), (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::toString).toList())));
            json.add(BLOCK_TAG_INHERITANCE_MODE, (JsonElement)new JsonPrimitive(config.blockTagInheritanceMode.toString()));
            json.add(BLOCK_TAG_INHERITANCE, (JsonElement)blockTagInheritance);
            json.add(IGNORED_TAGS, (JsonElement)JsonUtils.toArray(config.ignoredTags.stream().map(UnifyTag::location).map(ResourceLocation::toString).toList()));
            this.serializePatterns(json, IGNORED_ITEMS, config.ignoredItems);
            this.serializePatterns(json, IGNORED_RECIPE_TYPES, config.ignoredRecipeTypes);
            this.serializePatterns(json, IGNORED_RECIPES, config.ignoredRecipes);
            json.addProperty(HIDE_JEI_REI, Boolean.valueOf(config.hideJeiRei));
            return json;
        }
    }
}

