/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal;

import fuzs.puzzleslib.core.CoreServices;
import fuzs.universalbonemeal.UniversalBoneMeal;
import fuzs.universalbonemeal.config.ServerConfig;
import fuzs.universalbonemeal.handler.BonemealHandler;
import fuzs.universalbonemeal.world.level.block.behavior.CoralBehavior;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="universalbonemeal")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class UniversalBoneMealForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CoreServices.FACTORIES.modConstructor("universalbonemeal").accept(new UniversalBoneMeal());
        UniversalBoneMealForge.registerHandlers();
    }

    private static void registerHandlers() {
        BonemealHandler bonemealHandler = new BonemealHandler();
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            InteractionResult result = bonemealHandler.onBonemeal(evt.getLevel(), evt.getPos(), evt.getBlock(), evt.getStack());
            if (result == InteractionResult.SUCCESS) {
                evt.setResult(Event.Result.ALLOW);
            }
        });
        UniversalBoneMeal.CONFIG.getHolder(ServerConfig.class).accept(bonemealHandler::invalidate);
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            bonemealHandler.invalidate();
            CoralBehavior.invalidate();
        });
    }
}

