/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import java.util.LinkedList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class TitleRenderer<T> {
    public final LinkedList<T> recentEntries = new LinkedList();
    public Component displayedTitle = null;
    public Component displayedSubTitle = null;
    public int titleTimer = 0;
    public int cooldownTimer = 0;
    public int maxRecentListSize;
    public boolean enabled;
    public int titleFadeInTicks;
    public int titleDisplayTime;
    public int titleFadeOutTicks;
    public int titleTextcolor;
    public String titleDefaultTextColor;
    public boolean showTextShadow;
    public float titleTextSize;
    public float titleXOffset;
    public float titleYOffset;
    public boolean isTextCentered;

    public TitleRenderer(int maxRecentListSize, boolean enabled, int fadeInTicks, int displayTicks, int fadeOutTicks, String textColor, boolean showTextShadow, double textSize, double xOffset, double yOffset, boolean centerText) {
        this.maxRecentListSize = maxRecentListSize;
        this.enabled = enabled;
        this.titleFadeInTicks = fadeInTicks;
        this.titleDisplayTime = displayTicks;
        this.titleFadeOutTicks = fadeOutTicks;
        this.setColor(textColor);
        this.titleDefaultTextColor = textColor;
        this.showTextShadow = showTextShadow;
        this.titleTextSize = (float)textSize;
        this.titleXOffset = (float)xOffset;
        this.titleYOffset = (float)yOffset;
        this.isTextCentered = centerText;
    }

    public void renderText(float partialTicks, PoseStack poseStack) {
        if (this.displayedTitle != null && this.titleTimer > 0) {
            float age = (float)this.titleTimer - partialTicks;
            int opacity = 255;
            if (this.titleTimer > this.titleFadeOutTicks + this.titleDisplayTime) {
                float r = (float)(this.titleFadeInTicks + this.titleDisplayTime + this.titleFadeOutTicks) - age;
                opacity = (int)(r * 255.0f / (float)this.titleFadeInTicks);
            }
            if (this.titleTimer <= this.titleFadeOutTicks) {
                opacity = (int)(age * 255.0f / (float)this.titleFadeOutTicks);
            }
            if ((opacity = Mth.m_14045_((int)opacity, (int)0, (int)255)) > 8) {
                float xOffset;
                poseStack.m_85836_();
                if (this.isTextCentered) {
                    poseStack.m_85837_((double)Minecraft.m_91087_().m_91268_().m_85445_() / 2.0, (double)Minecraft.m_91087_().m_91268_().m_85446_() / 2.0, 0.0);
                }
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                poseStack.m_85836_();
                poseStack.m_85841_(this.titleTextSize, this.titleTextSize, this.titleTextSize);
                int alpha = opacity << 24 & 0xFF000000;
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                int titleWidth = fontRenderer.m_92852_((FormattedText)this.displayedTitle);
                this.drawTextBackground(poseStack, -10, titleWidth, this.titleTextcolor | alpha);
                float f = xOffset = this.isTextCentered ? this.titleXOffset + (float)(-titleWidth / 2) : this.titleXOffset;
                if (this.showTextShadow) {
                    fontRenderer.m_92763_(poseStack, this.displayedTitle, xOffset, this.titleYOffset, this.titleTextcolor | alpha);
                } else {
                    fontRenderer.m_92889_(poseStack, this.displayedTitle, xOffset, this.titleYOffset, this.titleTextcolor | alpha);
                }
                poseStack.m_85849_();
                if (this.displayedSubTitle != null) {
                    poseStack.m_85836_();
                    poseStack.m_85841_(1.3f, 1.3f, 1.3f);
                    int subtitleWidth = fontRenderer.m_92852_((FormattedText)this.displayedSubTitle);
                    this.drawTextBackground(poseStack, 5, subtitleWidth, 0xFFFFFF | alpha);
                    if (this.showTextShadow) {
                        fontRenderer.m_92763_(poseStack, this.displayedSubTitle, (float)(-subtitleWidth / 2), -35.0f, 0xFFFFFF | alpha);
                    } else {
                        fontRenderer.m_92889_(poseStack, this.displayedSubTitle, (float)(-subtitleWidth / 2), -35.0f, 0xFFFFFF | alpha);
                    }
                    poseStack.m_85849_();
                }
                RenderSystem.m_69461_();
                poseStack.m_85849_();
            }
        }
    }

    public void tick() {
        if (this.titleTimer > 0) {
            --this.titleTimer;
            if (this.titleTimer <= 0) {
                this.clearTimer();
            }
        }
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
        }
    }

    public void displayTitle(Component titleText, @Nullable Component subtitleText) {
        this.displayedTitle = titleText;
        this.titleTimer = this.titleFadeInTicks + this.titleDisplayTime + this.titleFadeOutTicks;
        if (subtitleText != null) {
            this.displayedSubTitle = subtitleText;
        }
    }

    public void clearTimer() {
        this.titleTimer = 0;
    }

    public void setColor(String textColor) {
        try {
            this.titleTextcolor = (int)Long.parseLong(textColor, 16);
        }
        catch (Exception e) {
            TravelersTitlesCommon.LOGGER.error("Text color {} is not a valid RGB color. Defaulting to white...", (Object)textColor);
            TravelersTitlesCommon.LOGGER.error(e.toString());
            this.titleTextcolor = 0xFFFFFF;
        }
    }

    public void addRecentEntry(T entry) {
        if (this.recentEntries.size() >= this.maxRecentListSize && this.recentEntries.size() > 0) {
            this.recentEntries.removeFirst();
        }
        if (this.maxRecentListSize > 0) {
            this.recentEntries.addLast(entry);
        }
    }

    public boolean matchesAnyRecentEntry(Predicate<T> entryMatchPredicate) {
        return this.recentEntries.stream().anyMatch(entryMatchPredicate);
    }

    protected void drawTextBackground(PoseStack mStack, int yOffset, int width, int color) {
        int textBackgroundColor = Minecraft.m_91087_().f_91066_.m_92170_(0.0f);
        if (textBackgroundColor != 0) {
            int xOffset = -width / 2;
            GuiComponent.m_93172_((PoseStack)mStack, (int)(xOffset - 2), (int)(yOffset - 2), (int)(xOffset + width + 2), (int)(yOffset + 9 + 2), (int)FastColor.ARGB32.m_13657_((int)textBackgroundColor, (int)color));
        }
    }
}

