/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.inventory;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sunekaer.toolkit.ToolkitPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public enum InventoryCollector {
    HAND("hand", player -> {
        ItemStack stack = player.m_21205_();
        return stack.m_41619_() ? List.of() : List.of(stack);
    }),
    OFFHAND("offhand", player -> {
        ItemStack stack = player.m_21206_();
        return stack.m_41619_() ? List.of() : List.of(stack);
    }),
    HOTBAR("hotbar", player -> {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_()) continue;
            items.add(stack);
        }
        return items;
    }),
    INVENTORY("inventory", player -> {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Inventory inventory = player.m_150109_();
        for (int i = 9; i < inventory.m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_()) continue;
            items.add(stack);
        }
        return items;
    }),
    INVENTORY_AND_HOTBAR("inventory_and_hotbar", player -> {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.addAll(InventoryCollector.HOTBAR.itemCollector.apply(player));
        items.addAll(InventoryCollector.INVENTORY.itemCollector.apply(player));
        return items;
    }),
    ARMOR("armor", player -> {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack slot : player.m_6168_()) {
            if (slot.m_41619_()) continue;
            items.add(slot);
        }
        return items;
    }),
    TARGET_INVENTORY("target_inventory", player -> {
        ArrayList items = new ArrayList();
        HitResult pick = player.m_19907_(20.0, 0.0f, true);
        if (!(pick instanceof BlockHitResult)) {
            return items;
        }
        BlockHitResult blockHit = (BlockHitResult)pick;
        Level level = player.f_19853_;
        return ToolkitPlatform.getInventoryFromBlockEntity(level, blockHit.m_82425_(), blockHit.m_82434_());
    });

    String name;
    ItemCollector itemCollector;

    private InventoryCollector(String name, ItemCollector itemCollector) {
        this.name = name;
        this.itemCollector = itemCollector;
    }

    public String getName() {
        return this.name;
    }

    public static InventoryCollector fromString(String name) {
        for (InventoryCollector type : InventoryCollector.values()) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static CompletableFuture<Suggestions> suggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
        Arrays.stream(InventoryCollector.values()).toList().forEach(type -> suggestionsBuilder.suggest(type.getName()));
        return CompletableFuture.completedFuture(suggestionsBuilder.build());
    }

    @FunctionalInterface
    static interface ItemCollector {
        public List<ItemStack> apply(Player var1);
    }
}

