/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.langs.SFMLLexer;
import ca.teamdman.langs.SFMLParser;
import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.DefaultProgramBehaviour;
import ca.teamdman.sfm.common.program.LimitedInputSlotObjectPool;
import ca.teamdman.sfm.common.program.LimitedOutputSlotObjectPool;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMTranslationUtils;
import ca.teamdman.sfml.ast.ASTBuilder;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.Statement;
import ca.teamdman.sfml.ast.ToStringCondensed;
import ca.teamdman.sfml.ast.Trigger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jetbrains.annotations.NotNull;

public record Program(ASTBuilder builder, String name, List<Trigger> triggers, Set<String> referencedLabels, Set<ResourceIdentifier<?, ?, ?>> referencedResources) implements Statement
{
    public static final int MAX_PROGRAM_LENGTH = 32367;
    public static final int MAX_LABEL_LENGTH = 256;

    public static void compile(String programString, Consumer<Program> onSuccess, Consumer<List<TranslatableContents>> onFailure) {
        Program program;
        ArrayList<TranslatableContents> errors;
        block8: {
            SFMLLexer lexer = new SFMLLexer((CharStream)CharStreams.fromString((String)programString));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SFMLParser parser = new SFMLParser((TokenStream)tokens);
            ASTBuilder builder = new ASTBuilder();
            lexer.removeErrorListeners();
            parser.removeErrorListeners();
            errors = new ArrayList<TranslatableContents>();
            ArrayList<String> buildErrors = new ArrayList<String>();
            ListErrorListener listener = new ListErrorListener(buildErrors);
            lexer.addErrorListener((ANTLRErrorListener)listener);
            parser.addErrorListener((ANTLRErrorListener)listener);
            SFMLParser.ProgramContext context = parser.program();
            buildErrors.stream().map(xva$0 -> LocalizationKeys.PROGRAM_ERROR_LITERAL.get(xva$0)).forEach(errors::add);
            program = null;
            if (errors.isEmpty()) {
                try {
                    program = builder.visitProgram(context);
                    Program.checkResourceTypes(program, errors);
                }
                catch (AssertionError | IllegalArgumentException | ResourceLocationException e) {
                    errors.add(LocalizationKeys.PROGRAM_ERROR_LITERAL.get(((Throwable)e).getMessage()));
                }
                catch (Throwable t) {
                    errors.add(LocalizationKeys.PROGRAM_ERROR_COMPILE_FAILED.get());
                    SFM.LOGGER.warn("Encountered unhandled error while compiling program\n```\n{}\n```", (Object)programString, (Object)t);
                    if (FMLEnvironment.production) break block8;
                    String message = t.getMessage();
                    if (message != null) {
                        errors.add(SFMTranslationUtils.getTranslatableContents(t.getClass().getSimpleName() + ": " + message));
                    }
                    errors.add(SFMTranslationUtils.getTranslatableContents(t.getClass().getSimpleName()));
                }
            }
        }
        if (program == null && errors.isEmpty()) {
            errors.add(LocalizationKeys.PROGRAM_ERROR_COMPILE_FAILED.get());
            SFM.LOGGER.error("Program was somehow null after a successful compile. I have no idea how this could happen, but it definitely shouldn't.\n```\n{}\n```", (Object)programString);
        }
        if (errors.isEmpty()) {
            onSuccess.accept(program);
        } else {
            onFailure.accept(errors);
        }
    }

    private static void checkResourceTypes(Program program, List<TranslatableContents> errors) {
        List<? extends String> disallowedResourceTypes = SFMConfig.getOrDefault(SFMConfig.SERVER.disallowedResourceTypesForTransfer);
        for (ResourceIdentifier<?, ?, ?> referencedResource : program.referencedResources) {
            try {
                ResourceType<?, ?, ?> resourceType = referencedResource.getResourceType();
                if (resourceType == null) {
                    errors.add(LocalizationKeys.PROGRAM_ERROR_UNKNOWN_RESOURCE_TYPE.get(referencedResource));
                    continue;
                }
                ResourceLocation resourceTypeId = Objects.requireNonNull(SFMResourceTypes.DEFERRED_TYPES.get().getKey(resourceType));
                if (!disallowedResourceTypes.contains(resourceTypeId.toString())) continue;
                errors.add(LocalizationKeys.PROGRAM_ERROR_DISALLOWED_RESOURCE_TYPE.get(referencedResource));
            }
            catch (ResourceLocationException e) {
                errors.add(LocalizationKeys.PROGRAM_ERROR_MALFORMED_RESOURCE_TYPE.get(referencedResource));
            }
        }
    }

    public boolean tick(ManagerBlockEntity manager) {
        ProgramContext context = new ProgramContext(this, manager, new DefaultProgramBehaviour());
        int unprocessedRedstonePulseCount = manager.getUnprocessedRedstonePulseCount();
        if (unprocessedRedstonePulseCount > 0) {
            manager.logger.debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_WITH_REDSTONE_COUNT.get(unprocessedRedstonePulseCount)));
        }
        this.tick(context);
        manager.clearRedstonePulseQueue();
        return context.didSomething();
    }

    @Override
    public List<Statement> getStatements() {
        return this.triggers;
    }

    @Override
    public void tick(ProgramContext context) {
        LimitedInputSlotObjectPool.checkInvariant();
        LimitedOutputSlotObjectPool.checkInvariant();
        for (Trigger trigger : this.triggers) {
            List<Trigger> list;
            if (!trigger.shouldTick(context)) continue;
            if (!context.didSomething()) {
                context.setDidSomething(true);
                context.getLogger().trace(Program.getTraceLogWriter(context));
                context.getLogger().debug(debug -> debug.accept(LocalizationKeys.LOG_PROGRAM_TICK.get()));
            }
            if ((list = this.triggers) instanceof ToStringCondensed) {
                ToStringCondensed ss = (ToStringCondensed)((Object)list);
                context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_TRIGGER_STATEMENT.get(ss.toStringCondensed())));
            }
            long start = System.nanoTime();
            ProgramBehaviour programBehaviour = context.getBehaviour();
            if (programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour) {
                SimulateExploreAllPathsProgramBehaviour simulation = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
                int maxConditionCount = (Integer)SFMConfig.getOrDefault(SFMConfig.SERVER.maxIfStatementsInTriggerBeforeSimulationIsntAllowed);
                int conditionCount = trigger.getConditionCount();
                if (conditionCount <= maxConditionCount) {
                    int numPossibleStates = (int)Math.max(1.0, Math.pow(2.0, conditionCount));
                    for (int i = 0; i < numPossibleStates; ++i) {
                        ProgramContext forkedContext = context.fork();
                        trigger.tick(forkedContext);
                        forkedContext.free();
                        ((SimulateExploreAllPathsProgramBehaviour)forkedContext.getBehaviour()).terminatePathAndBeginAnew();
                    }
                } else {
                    context.getLogger().warn(LocalizationKeys.PROGRAM_WARNING_TOO_MANY_CONDITIONS.get(trigger.toString(), conditionCount, maxConditionCount));
                }
                simulation.prepareNextTrigger();
            } else {
                ProgramContext forkedContext = context.fork();
                trigger.tick(forkedContext);
                forkedContext.free();
            }
            long nanoTimePassed = System.nanoTime() - start;
            context.getLogger().info(x -> x.accept(LocalizationKeys.PROGRAM_TICK_TRIGGER_TIME_MS.get((double)nanoTimePassed / 1000000.0, trigger.toString())));
        }
        LimitedInputSlotObjectPool.checkInvariant();
        LimitedOutputSlotObjectPool.checkInvariant();
        ProgramBehaviour programBehaviour = context.getBehaviour();
        if (programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour) {
            SimulateExploreAllPathsProgramBehaviour simulation = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
            simulation.onProgramFinished(context, this);
        }
    }

    public int getConditionIndex(IfStatement ifStatement) {
        for (Trigger trigger : this.triggers) {
            int conditionIndex = trigger.getConditionIndex(ifStatement);
            if (conditionIndex == -1) continue;
            return conditionIndex;
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder rtn = new StringBuilder();
        rtn.append("NAME \"").append(this.name).append("\"\n");
        for (Trigger trigger : this.triggers) {
            rtn.append(trigger).append("\n");
        }
        return rtn.toString();
    }

    public void replaceOutputStatement(OutputStatement oldStatement, OutputStatement newStatement) {
        ArrayDeque<Statement> toPatch = new ArrayDeque<Statement>();
        toPatch.add(this);
        while (!toPatch.isEmpty()) {
            Statement statement = (Statement)toPatch.pollFirst();
            List<Statement> children = statement.getStatements();
            for (int i = 0; i < children.size(); ++i) {
                Statement child = children.get(i);
                if (child == oldStatement) {
                    children.set(i, newStatement);
                    continue;
                }
                toPatch.add(child);
            }
        }
    }

    @NotNull
    private static Consumer<Consumer<TranslatableContents>> getTraceLogWriter(ProgramContext context) {
        return trace -> {
            trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_HEADER_1.get());
            trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_HEADER_2.get());
            Level level = context.getManager().m_58904_();
            context.getNetwork().getCablePositions().map(pos -> "- " + pos.toString() + " " + level.m_8055_(pos)).forEach(body -> trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_BODY.get(body)));
            trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_HEADER_3.get());
            context.getNetwork().getCapabilityProviderPositions().map(pos -> "- " + pos.toString() + " " + level.m_8055_(pos)).forEach(body -> trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_BODY.get(body)));
            trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_FOOTER.get());
            trace.accept(LocalizationKeys.LOG_LABEL_POSITION_HOLDER_DETAILS_HEADER.get());
            context.getLabelPositionHolder().labels().forEach((label, positions) -> positions.stream().map(pos -> "- " + label + ": " + pos.toString() + " " + level.m_8055_(pos)).forEach(body -> trace.accept(LocalizationKeys.LOG_LABEL_POSITION_HOLDER_DETAILS_BODY.get(body))));
            trace.accept(LocalizationKeys.LOG_LABEL_POSITION_HOLDER_DETAILS_FOOTER.get());
            trace.accept(LocalizationKeys.LOG_PROGRAM_CONTEXT.get(context));
        };
    }

    public static class ListErrorListener
    extends BaseErrorListener {
        private final List<String> errors;

        public ListErrorListener(List<String> errors) {
            this.errors = errors;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.errors.add("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

