/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.chat.contents.TranslatableContents;

public class GatherWarningsProgramBehaviour
extends SimulateExploreAllPathsProgramBehaviour {
    private final List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPath, List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>>>> sharedMultiverseWarningsByPath;
    private final Consumer<Collection<TranslatableContents>> sharedMultiverseWarningDisplay;
    private final List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>> warnings = new ArrayList<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>>();
    private final Multimap<ResourceType, Label> resourceTypesInputted = HashMultimap.create();
    private final Set<ResourceType> resourceTypesOutputted = new HashSet<ResourceType>();

    public GatherWarningsProgramBehaviour(Consumer<Collection<TranslatableContents>> sharedMultiverseWarningDisplay) {
        this.sharedMultiverseWarningDisplay = sharedMultiverseWarningDisplay;
        this.sharedMultiverseWarningsByPath = new ArrayList<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPath, List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>>>>();
    }

    public GatherWarningsProgramBehaviour(List<SimulateExploreAllPathsProgramBehaviour.ExecutionPath> seenPaths, SimulateExploreAllPathsProgramBehaviour.ExecutionPath currentPath, AtomicReference<BigInteger> triggerPathCount, Consumer<Collection<TranslatableContents>> sharedMultiverseWarningDisplay, List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPath, List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>>>> sharedMultiverseWarningsByPath, List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>> warnings) {
        super(seenPaths, currentPath, triggerPathCount);
        this.warnings.addAll(warnings);
        this.sharedMultiverseWarningDisplay = sharedMultiverseWarningDisplay;
        this.sharedMultiverseWarningsByPath = sharedMultiverseWarningsByPath;
    }

    @Override
    public ProgramBehaviour fork() {
        return new GatherWarningsProgramBehaviour(this.seenPaths, this.currentPath, this.triggerPathCount, this.sharedMultiverseWarningDisplay, this.sharedMultiverseWarningsByPath, this.warnings);
    }

    @Override
    public void onInputStatementExecution(ProgramContext context, InputStatement inputStatement) {
        super.onInputStatementExecution(context, inputStatement);
        Set inputtingResourceTypes = inputStatement.getReferencedIOResourceIds().map(ResourceIdentifier::getResourceType).collect(Collectors.toSet());
        for (Label label : inputStatement.labelAccess().labels()) {
            for (ResourceType resourceType : inputtingResourceTypes) {
                this.resourceTypesInputted.put((Object)resourceType, (Object)label);
            }
        }
    }

    @Override
    public void onOutputStatementExecution(ProgramContext context, OutputStatement outputStatement) {
        super.onOutputStatementExecution(context, outputStatement);
        Set seekingResourceTypes = outputStatement.getReferencedIOResourceIds().map(ResourceIdentifier::getResourceType).collect(Collectors.toSet());
        for (ResourceType resourceType : seekingResourceTypes) {
            if (this.resourceTypesInputted.containsKey((Object)resourceType)) continue;
            this.warnings.add((Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>)Pair.of((Object)this.getLatestPathElement(), (Object)LocalizationKeys.PROGRAM_WARNING_OUTPUT_RESOURCE_TYPE_NOT_FOUND_IN_INPUTS.get(outputStatement, context.getProgram().builder().getLineColumnForNode(outputStatement), resourceType.displayAsCode())));
        }
        this.resourceTypesOutputted.addAll(seekingResourceTypes);
    }

    @Override
    public void onInputStatementForgetTransform(ProgramContext context, InputStatement old, InputStatement next) {
        super.onInputStatementForgetTransform(context, old, next);
        HashSet<Label> oldLabels = new HashSet<Label>(old.labelAccess().labels());
        HashSet<Label> newLabels = new HashSet<Label>(next.labelAccess().labels());
        HashSet<Label> removedLabels = new HashSet<Label>(oldLabels);
        removedLabels.removeAll(newLabels);
        Set droppingResourceTypes = old.getReferencedIOResourceIds().map(ResourceIdentifier::getResourceType).collect(Collectors.toSet());
        this.warnUnusedInputLabels(context, old, removedLabels, droppingResourceTypes);
    }

    @Override
    public void terminatePathAndBeginAnew() {
        this.sharedMultiverseWarningsByPath.add((Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPath, List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>>>)Pair.of((Object)this.currentPath, new ArrayList<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>>(this.warnings)));
        super.terminatePathAndBeginAnew();
        this.warnings.clear();
    }

    @Override
    public void onInputStatementDropped(ProgramContext context, InputStatement inputStatement) {
        super.onInputStatementDropped(context, inputStatement);
        Set droppingResourceTypes = inputStatement.getReferencedIOResourceIds().map(ResourceIdentifier::getResourceType).collect(Collectors.toSet());
        HashSet<Label> droppingLabels = new HashSet<Label>(inputStatement.labelAccess().labels());
        this.warnUnusedInputLabels(context, inputStatement, droppingLabels, droppingResourceTypes);
    }

    @Override
    public void onProgramFinished(ProgramContext context, Program program) {
        super.onProgramFinished(context, program);
        HashSet toWarn = new HashSet();
        for (Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPath, List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>>> path : this.sharedMultiverseWarningsByPath) {
            toWarn.addAll((Collection)path.getSecond());
        }
        Iterator iterator = toWarn.iterator();
        block1: while (iterator.hasNext()) {
            Pair seekPair = (Pair)iterator.next();
            SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement seekStatement = (SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement)seekPair.getFirst();
            TranslatableContents seekWarning = (TranslatableContents)seekPair.getSecond();
            for (Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPath, List<Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>>> histPair : this.sharedMultiverseWarningsByPath) {
                boolean pathContainsStatement = ((SimulateExploreAllPathsProgramBehaviour.ExecutionPath)histPair.getFirst()).stream().anyMatch(element -> element.equals(seekStatement));
                boolean pathContainsWarning = ((List)histPair.getSecond()).stream().anyMatch(pair -> ((TranslatableContents)pair.getSecond()).equals((Object)seekWarning));
                if (!pathContainsStatement || pathContainsWarning) continue;
                iterator.remove();
                continue block1;
            }
        }
        this.sharedMultiverseWarningDisplay.accept(toWarn.stream().map(Pair::getSecond).collect(Collectors.toSet()));
    }

    private void warnUnusedInputLabels(ProgramContext context, InputStatement old, Set<Label> removedLabels, Set<? extends ResourceType<?, ?, ?>> droppingResourceTypes) {
        for (Label label : removedLabels) {
            for (ResourceType<?, ?, ?> resourceType : droppingResourceTypes) {
                if (!this.resourceTypesOutputted.contains(resourceType)) {
                    SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement offendingNode = this.getPathElementForNode(old);
                    if (offendingNode == null) {
                        SFM.LOGGER.warn("Failed to find node for element during warning generation: {}", (Object)old);
                    }
                    this.warnings.add((Pair<SimulateExploreAllPathsProgramBehaviour.ExecutionPathElement, TranslatableContents>)Pair.of((Object)offendingNode, (Object)LocalizationKeys.PROGRAM_WARNING_UNUSED_INPUT_LABEL.get(old, context.getProgram().builder().getLineColumnForNode(old), resourceType.displayAsCode(), label, resourceType.displayAsCode())));
                }
                this.resourceTypesInputted.remove(resourceType, (Object)label);
            }
        }
    }
}

