/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.facade;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.blockentity.IFacadeBlockEntity;
import ca.teamdman.sfm.common.facade.FacadeData;
import ca.teamdman.sfm.common.facade.FacadePlanAnalysisResult;
import ca.teamdman.sfm.common.facade.FacadePlanWarning;
import ca.teamdman.sfm.common.facade.FacadeTransparency;
import ca.teamdman.sfm.common.facade.IFacadePlan;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record ChangeWorldBlockFacadePlan(IFacadableBlock worldBlock, Set<BlockPos> positions) implements IFacadePlan
{
    @Override
    public void apply(Level level) {
        this.positions().forEach(pos -> {
            BlockEntity patt843$temp = level.m_7702_(pos);
            if (patt843$temp instanceof IFacadeBlockEntity) {
                IFacadeBlockEntity oldFacadeBlockEntity = (IFacadeBlockEntity)patt843$temp;
                BlockState oldState = level.m_8055_(pos);
                FacadeData oldFacadeData = oldFacadeBlockEntity.getFacadeData();
                if (oldFacadeData != null && oldState.m_61138_(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY)) {
                    level.m_7731_(pos, this.worldBlock().getFacadeBlock().getStateForPlacementByFacadePlan((LevelAccessor)level, (BlockPos)pos, (FacadeTransparency)((Object)((Object)oldState.m_61143_(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY)))), 10);
                    BlockEntity blockEntity = level.m_7702_(pos);
                    if (blockEntity instanceof IFacadeBlockEntity) {
                        IFacadeBlockEntity facadeBlockEntity = (IFacadeBlockEntity)blockEntity;
                        facadeBlockEntity.updateFacadeData(oldFacadeData);
                    } else {
                        SFM.LOGGER.warn("Block entity {} at {} is not a facade block entity", pos, (Object)blockEntity);
                    }
                }
            } else {
                level.m_7731_(pos, this.worldBlock().getNonFacadeBlock().getStateForPlacementByFacadePlan((LevelAccessor)level, (BlockPos)pos, null), 10);
            }
        });
    }

    @Override
    @Nullable
    public FacadePlanWarning computeWarning(Level level) {
        FacadePlanAnalysisResult analysisResult = FacadePlanAnalysisResult.analyze(level, this.positions);
        if (analysisResult.shouldWarn()) {
            return FacadePlanWarning.of(LocalizationKeys.FACADE_CONFIRM_CHANGE_WORLD_BLOCK_SCREEN_TITLE.getComponent(), LocalizationKeys.FACADE_CONFIRM_CHANGE_WORLD_BLOCK_SCREEN_MESSAGE.getComponent(analysisResult.countAffected()));
        }
        return null;
    }
}

