/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.SFM;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class SFMConfig {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final SFMServerConfig SERVER;
    public static final SFMClientConfig CLIENT;

    public static <T> T getOrDefault(ForgeConfigSpec.ConfigValue<T> configValue) {
        try {
            return (T)configValue.get();
        }
        catch (Exception e) {
            return (T)configValue.getDefault();
        }
    }

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    static {
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(SFMServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (SFMServerConfig)serverSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(SFMClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (SFMClientConfig)clientSpecPair.getLeft();
    }

    @Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class SFMServerConfig {
        public final ForgeConfigSpec.BooleanValue disableProgramExecution;
        public final ForgeConfigSpec.BooleanValue logResourceLossToConsole;
        public final ForgeConfigSpec.IntValue timerTriggerMinimumIntervalInTicks;
        public final ForgeConfigSpec.IntValue timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO;
        public final ForgeConfigSpec.IntValue maxIfStatementsInTriggerBeforeSimulationIsntAllowed;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> disallowedResourceTypesForTransfer;
        public final ForgeConfigSpec.EnumValue<LevelsToShards> levelsToShards;
        private int revision = 0;

        SFMServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("This config is shown to clients, don't put anything secret in here");
            this.disableProgramExecution = builder.comment("Prevents factory managers from compiling and running code (for emergencies)").define("disableProgramExecution", false);
            this.logResourceLossToConsole = builder.comment("Log resource loss to console").define("logResourceLossToConsole", true);
            this.timerTriggerMinimumIntervalInTicks = builder.defineInRange("timerTriggerMinimumIntervalInTicks", 20, 1, Integer.MAX_VALUE);
            this.timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO = builder.defineInRange("timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIOStatementsPresent", 1, 1, Integer.MAX_VALUE);
            this.maxIfStatementsInTriggerBeforeSimulationIsntAllowed = builder.comment("The number of scenarios to check is 2^n where n is the number of if statements in a trigger").defineInRange("maxIfStatementsInTriggerBeforeSimulationIsntAllowed", 10, 0, Integer.MAX_VALUE);
            this.disallowedResourceTypesForTransfer = builder.comment("What resource types should SFM not be allowed to move").defineListAllowEmpty(List.of("disallowedResourceTypesForTransfer"), List::of, String.class::isInstance);
            this.levelsToShards = builder.comment(new String[]{"How to convert Enchanted Books to Experience Shards", "JustOne = always produces 1 shard regardless of enchantments", "EachOne = produces 1 shard per enchantment on the book.", "SumLevels = produces a number of shards equal to the sum of the enchantments' levels", "SumLevelsScaledExponentially = produces a number of shards equal to the sum of 2 to the power of each enchantment's level (1 -> 1 shard, 2 -> 4 shards, 3 -> 8 shards, etc)"}).defineEnum("levelsToShards", (Enum)LevelsToShards.JustOne);
        }

        public int getRevision() {
            return this.revision;
        }

        @SubscribeEvent
        public static void onConfigLoaded(ModConfigEvent.Loading event) {
            if (event.getConfig().getSpec() == SERVER_SPEC) {
                ++SFMConfig.SERVER.revision;
                SFM.LOGGER.info("SFM config loaded, now on revision {}", (Object)SFMConfig.SERVER.revision);
            }
        }

        @SubscribeEvent
        public static void onConfigReloaded(ModConfigEvent.Reloading event) {
            if (event.getConfig().getSpec() == SERVER_SPEC) {
                ++SFMConfig.SERVER.revision;
                SFM.LOGGER.info("SFM config reloaded, now on revision {}", (Object)SFMConfig.SERVER.revision);
            }
        }

        public static enum LevelsToShards {
            JustOne,
            EachOne,
            SumLevels,
            SumLevelsScaledExponentially;

        }
    }

    public static class SFMClientConfig {
        public final ForgeConfigSpec.BooleanValue showLineNumbers;
        public final ForgeConfigSpec.BooleanValue showLabelGunReminderOverlay;
        public final ForgeConfigSpec.BooleanValue showNetworkToolReminderOverlay;

        SFMClientConfig(ForgeConfigSpec.Builder builder) {
            this.showLineNumbers = builder.define("showLineNumbers", false);
            this.showLabelGunReminderOverlay = builder.define("showLabelGunReminderOverlay", true);
            this.showNetworkToolReminderOverlay = builder.define("showNetworkToolReminderOverlay", true);
        }
    }
}

