/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrot;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class PageFlipButton
extends Button {
    private static final ResourceLocation texture = SOLCarrot.resourceLocation("textures/gui/food_book.png");
    public static final int width = 23;
    public static final int height = 13;
    private final Direction direction;
    private final Pageable pageable;

    PageFlipButton(int x, int y, Direction direction, Pageable pageable) {
        super(x, y, 23, 13, (Component)Component.m_237119_(), button -> ((PageFlipButton)button).changePage());
        this.direction = direction;
        this.pageable = pageable;
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        boolean isHovered;
        if (!this.f_93624_) {
            return;
        }
        int textureX = 0;
        boolean bl = isHovered = this.f_93620_ <= mouseX && mouseX < this.f_93620_ + 23 && this.f_93621_ <= mouseY && mouseY < this.f_93621_ + 13;
        if (isHovered) {
            textureX += 23;
        }
        int textureY = 192;
        if (this.direction == Direction.BACKWARD) {
            textureY += 13;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        PageFlipButton.m_93143_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (int)0, (float)textureX, (float)textureY, (int)23, (int)13, (int)256, (int)256);
    }

    public void updateState() {
        this.f_93624_ = this.pageable.isWithinRange(this.pageable.getCurrentPageNumber() + this.direction.distance);
    }

    private void changePage() {
        this.pageable.switchToPage(this.pageable.getCurrentPageNumber() + this.direction.distance);
    }

    public void m_7435_(SoundManager soundManager) {
        soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
    }

    static enum Direction {
        FORWARD(1),
        BACKWARD(-1);

        final int distance;

        private Direction(int distance) {
            this.distance = distance;
        }
    }

    static interface Pageable {
        public void switchToPage(int var1);

        public int getCurrentPageNumber();

        public boolean isWithinRange(int var1);
    }
}

