/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public abstract class HeldBehaviour<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    protected Function<E, Boolean> tickConsumer = entity -> true;
    protected int runningTime = 0;

    public HeldBehaviour() {
        this.runFor(entity -> Integer.MAX_VALUE);
    }

    public HeldBehaviour<E> onTick(Function<E, Boolean> tickConsumer) {
        this.tickConsumer = tickConsumer;
        return this;
    }

    public int getRunningTime() {
        return this.runningTime;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return true;
    }

    @Override
    protected void m_6735_(ServerLevel level, E entity, long gameTime) {
        super.m_6735_(level, entity, gameTime);
        this.runningTime = 0;
    }

    @Override
    protected void m_6725_(ServerLevel level, E owner, long gameTime) {
        super.m_6725_(level, owner, gameTime);
        if (!this.tickConsumer.apply(owner).booleanValue()) {
            this.m_22562_(level, (LivingEntity)owner, gameTime);
        }
        ++this.runningTime;
    }
}

