/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.capability;

import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ManaCapability
implements IManaCapability,
ICapabilitySerializable<CompoundTag> {
    private float maxMana = 40.0f;
    private float mana = 40.0f;

    @Override
    public float getMana() {
        return this.mana;
    }

    @Override
    public float getMaxMana() {
        return this.maxMana;
    }

    @Override
    public void setMana(float mana) {
        this.mana = mana;
        if (mana < 0.0f) {
            this.mana = 0.0f;
        }
        if (mana > this.getMaxMana()) {
            this.mana = this.getMaxMana();
        }
    }

    @Override
    public void setMaxMana(float maxMana) {
        this.maxMana = maxMana;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return RootsCapabilityManager.MANA_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public CompoundTag serializeNBT() {
        return this.writeNBT(this);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.readNBT(this, nbt);
    }

    public CompoundTag writeNBT(ManaCapability instance) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("mana", instance.getMana());
        tag.m_128350_("maxMana", instance.getMaxMana());
        return tag;
    }

    public void readNBT(ManaCapability instance, CompoundTag tag) {
        instance.setMana(tag.m_128457_("mana"));
        instance.setMaxMana(tag.m_128457_("maxMana"));
    }
}

