/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.session;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.resources.SplashManager;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.SessionData;
import technicianlp.reauth.session.SessionChecker;
import technicianlp.reauth.util.ReflectionUtils;

public final class SessionHelper {
    private static final Field userField = ReflectionUtils.findObfuscatedField(Minecraft.class, "f_90998_", "user");
    private static final Field userApiServiceField = ReflectionUtils.findObfuscatedField(Minecraft.class, "f_193584_", "userApiService");
    private static final Field socialManagerField = ReflectionUtils.findObfuscatedField(Minecraft.class, "f_91006_", "playerSocialManager");
    private static final Field splashesSessionField = ReflectionUtils.findObfuscatedField(SplashManager.class, "f_118863_", "user");
    private static final Pattern usernamePattern = Pattern.compile("[A-Za-z0-9_]{2,16}");

    public static void setOfflineUsername(String username) {
        UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
        SessionHelper.setSession(new SessionData(username, uuid.toString(), "invalid", "legacy"), false);
    }

    public static void setSession(SessionData data) {
        SessionHelper.setSession(data, true);
    }

    private static void setSession(SessionData data, boolean online) {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            User session = new User(data.username, data.uuid, data.accessToken, Optional.empty(), Optional.empty(), User.Type.m_92561_((String)data.type));
            ReflectionUtils.setField(userField, minecraft, session);
            SessionChecker.invalidate();
            minecraft.m_91095_().clear();
            minecraft.m_91095_();
            UserApiService userApiService = null;
            if (online) {
                YggdrasilMinecraftSessionService sessionService = (YggdrasilMinecraftSessionService)minecraft.m_91108_();
                YggdrasilAuthenticationService authService = sessionService.getAuthenticationService();
                try {
                    userApiService = authService.createUserApiService(session.m_92547_());
                }
                catch (AuthenticationException authenticationexception) {
                    ReAuth.log.error("Failed to create UserApiService", (Throwable)authenticationexception);
                }
            }
            if (userApiService == null) {
                userApiService = UserApiService.OFFLINE;
            }
            ReflectionUtils.setField(userApiServiceField, minecraft, userApiService);
            PlayerSocialManager socialManager = new PlayerSocialManager(minecraft, userApiService);
            ReflectionUtils.setField(socialManagerField, minecraft, socialManager);
            ReflectionUtils.setField(splashesSessionField, minecraft.m_91310_(), session);
        }
        catch (Exception e) {
            ReAuth.log.error("Failed to update Session", (Throwable)e);
        }
    }

    public static boolean isValidOfflineUsername(String username) {
        return usernamePattern.matcher(username).matches();
    }
}

