/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.undergroundstyle;

import it.unimi.dsi.fastutil.ints.Int2ByteArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.content.world.block.CorundumBlock;
import vazkii.quark.content.world.block.CorundumClusterBlock;
import vazkii.quark.content.world.module.CorundumModule;
import vazkii.quark.content.world.undergroundstyle.base.BasicUndergroundStyle;
import vazkii.quark.content.world.undergroundstyle.base.UndergroundStyleGenerator;

public class CorundumStyle
extends BasicUndergroundStyle {
    private static final Int2ByteMap CRYSTAL_DATA = new Int2ByteArrayMap();

    public CorundumStyle() {
        super(Blocks.f_50016_.m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_());
    }

    @Override
    public void fillCeiling(UndergroundStyleGenerator.Context context, BlockPos pos, BlockState state) {
        int floorIdx;
        byte raw = CorundumStyle.calculateRawColorData(context.source);
        int ceilIdx = raw >> 4 & 0xF;
        if (ceilIdx >= (floorIdx = raw & 0xF)) {
            ++ceilIdx;
        }
        if (context.random.nextDouble() < CorundumModule.crystalChance) {
            CorundumStyle.makeCrystalIfApt(context, pos, Direction.DOWN, ceilIdx);
        }
    }

    @Override
    public void fillFloor(UndergroundStyleGenerator.Context context, BlockPos pos, BlockState state) {
        byte raw = CorundumStyle.calculateRawColorData(context.source);
        int floorIdx = raw & 0xF;
        if (context.random.nextDouble() < CorundumModule.crystalChance) {
            CorundumStyle.makeCrystalIfApt(context, pos, Direction.UP, floorIdx);
        }
    }

    private static void makeCrystalIfApt(UndergroundStyleGenerator.Context context, BlockPos pos, Direction offset, int color) {
        BlockPos crystalPos = pos.m_121945_(offset);
        boolean hasHorizontal = false;
        WorldGenRegion world = context.world;
        for (Direction dir : MiscUtil.HORIZONTALS) {
            BlockPos testPos = crystalPos.m_121945_(dir);
            if (!world.m_8055_(testPos).m_60815_()) continue;
            hasHorizontal = true;
            break;
        }
        if (!hasHorizontal) {
            return;
        }
        CorundumStyle.makeCrystalAt(context, crystalPos, offset, color, CorundumModule.crystalClusterChance);
        if (context.random.nextDouble() < CorundumModule.doubleCrystalChance && world.m_46859_(crystalPos = crystalPos.m_121945_(offset))) {
            CorundumStyle.makeCrystalAt(context, crystalPos, offset, color, 0.0);
        }
    }

    private static void makeCrystalAt(UndergroundStyleGenerator.Context context, BlockPos crystalPos, Direction offset, int color, double clusterChance) {
        CorundumBlock crystal = CorundumModule.crystals.get(color);
        CorundumClusterBlock cluster = crystal.cluster;
        WorldGenRegion world = context.world;
        if (context.random.nextDouble() < clusterChance) {
            world.m_7731_(crystalPos, (BlockState)((BlockState)cluster.m_49966_().m_61124_(CorundumClusterBlock.FACING, (Comparable)offset)).m_61124_((Property)CorundumClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(crystalPos).m_76152_() == Fluids.f_76193_)), 0);
        } else {
            world.m_7731_(crystalPos, crystal.m_49966_(), 0);
            for (Direction dir : Direction.values()) {
                BlockPos clusterPos = crystalPos.m_121945_(dir);
                if (!world.m_46859_(clusterPos) || !(context.random.nextDouble() < CorundumModule.crystalClusterOnSidesChance)) continue;
                world.m_7731_(clusterPos, (BlockState)((BlockState)cluster.m_49966_().m_61124_(CorundumClusterBlock.FACING, (Comparable)dir)).m_61124_((Property)CorundumClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(clusterPos).m_76152_() == Fluids.f_76193_)), 0);
            }
        }
    }

    private static byte calculateRawColorData(BlockPos source) {
        return CRYSTAL_DATA.computeIfAbsent(source.hashCode(), src -> {
            Random rand = new Random(src);
            return (byte)(rand.nextInt(8) << 4 | rand.nextInt(9));
        });
    }
}

