/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.material.Material;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.content.building.module.CompressedBlocksModule;
import vazkii.quark.content.world.module.NetherObsidianSpikesModule;

public class ObsidianSpikeGenerator
extends Generator {
    public ObsidianSpikeGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    @Override
    public void generateChunk(WorldGenRegion world, ChunkGenerator generator, RandomSource rand, BlockPos chunkCorner) {
        if ((double)rand.m_188501_() < NetherObsidianSpikesModule.chancePerChunk) {
            block0: for (int i = 0; i < NetherObsidianSpikesModule.triesPerChunk; ++i) {
                BlockPos pos = chunkCorner.m_7918_(rand.m_188503_(16), 50, rand.m_188503_(16));
                while (pos.m_123342_() > 10) {
                    BlockState state = world.m_8055_(pos);
                    if (state.m_60734_() == Blocks.f_49991_) {
                        ObsidianSpikeGenerator.placeSpikeAt((LevelAccessor)world, pos, rand);
                        continue block0;
                    }
                    pos = pos.m_7495_();
                }
            }
        }
    }

    public static void placeSpikeAt(LevelAccessor world, BlockPos pos, RandomSource rand) {
        int i;
        int heightBelow = 10;
        int heightBottom = 3 + rand.m_188503_(3);
        int heightMiddle = 2 + rand.m_188503_(4);
        int heightTop = 2 + rand.m_188503_(3);
        boolean addSpawner = false;
        if ((double)rand.m_188501_() < NetherObsidianSpikesModule.bigSpikeChance) {
            heightBottom += 7;
            heightMiddle += 8;
            heightTop += 4;
            addSpawner = NetherObsidianSpikesModule.bigSpikeSpawners;
        }
        int checkHeight = heightBottom + heightMiddle + heightTop + 2;
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < checkHeight; ++k) {
                    BlockPos checkPos = pos.m_7918_(i2 - 2, k, j - 2);
                    if (world.m_46859_(checkPos) || world.m_8055_(checkPos).m_60767_() == Material.f_76307_) continue;
                    return;
                }
            }
        }
        BlockState obsidian = Blocks.f_50080_.m_49966_();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < heightBottom + heightBelow; ++k) {
                    BlockPos placePos = pos.m_7918_(i - 1, k - heightBelow, j - 1);
                    if (world.m_8055_(placePos).m_60800_((BlockGetter)world, placePos) == -1.0f) continue;
                    world.m_7731_(placePos, obsidian, 0);
                }
            }
        }
        for (i = 0; i < heightMiddle; ++i) {
            BlockPos placePos = pos.m_7918_(0, heightBottom + i, 0);
            world.m_7731_(placePos, obsidian, 0);
            for (Direction face : MiscUtil.HORIZONTALS) {
                world.m_7731_(placePos.m_121945_(face), obsidian, 0);
            }
        }
        for (i = 0; i < heightTop; ++i) {
            BlockPos placePos = pos.m_7918_(0, heightBottom + heightMiddle + i, 0);
            world.m_7731_(placePos, obsidian, 0);
            if (!addSpawner || i != 0) continue;
            boolean useBlazeLantern = ModuleLoader.INSTANCE.isModuleEnabled(CompressedBlocksModule.class) && CompressedBlocksModule.enableBlazeLantern;
            world.m_7731_(placePos, useBlazeLantern ? CompressedBlocksModule.blaze_lantern.m_49966_() : Blocks.f_50141_.m_49966_(), 0);
            placePos = placePos.m_7495_();
            world.m_7731_(placePos, Blocks.f_50085_.m_49966_(), 0);
            ((SpawnerBlockEntity)world.m_7702_(placePos)).m_59801_().m_45462_(EntityType.f_20551_);
            placePos = placePos.m_7495_();
            world.m_7731_(placePos, Blocks.f_50087_.m_49966_(), 0);
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)rand, (BlockPos)placePos, (ResourceLocation)new ResourceLocation("minecraft", "chests/nether_bridge"));
        }
    }
}

