/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import vazkii.quark.base.block.QuarkSaplingBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.module.AncientWoodModule;

public class AncientSaplingBlock
extends QuarkSaplingBlock {
    public AncientSaplingBlock(QuarkModule module) {
        super("ancient", module, new AncientTree());
    }

    public static class AncientTree
    extends AbstractTreeGrower {
        public final TreeConfiguration config;

        public AncientTree() {
            this.config = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)AncientWoodModule.woodSet.log), (TrunkPlacer)new MultiFolliageStraightTrunkPlacer(17, 4, 6, 5, 3), (BlockStateProvider)BlockStateProvider.m_191382_((Block)AncientWoodModule.ancient_leaves), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)UniformInt.m_146622_((int)2, (int)4), (IntProvider)ConstantInt.m_146483_((int)-3), 2), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68249_((List)Lists.newArrayList((Object[])new TreeDecorator[]{new AncientTreeTopperDecorator()})).m_68244_().m_68251_();
        }

        protected Holder<ConfiguredFeature<TreeConfiguration, ?>> m_213888_(@Nonnull RandomSource rand, boolean hjskfsd) {
            return Holder.m_205709_((Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)this.config));
        }
    }

    public static class AncientTreeTopperDecorator
    extends TreeDecorator {
        public void m_214187_(TreeDecorator.Context ctx) {
            Optional pos = ctx.m_226068_().stream().max((a, b) -> a.m_123342_() - b.m_123342_());
            if (pos.isPresent()) {
                BlockPos top = (BlockPos)pos.get();
                ImmutableSet leafPos = ImmutableSet.of((Object)top.m_7494_(), (Object)top.m_122029_(), (Object)top.m_122024_(), (Object)top.m_122012_(), (Object)top.m_122019_());
                BlockState state = AncientWoodModule.ancient_leaves.m_49966_();
                leafPos.forEach(p -> {
                    if (ctx.m_226059_(p)) {
                        ctx.m_226061_(p, state);
                    }
                });
            }
        }

        protected TreeDecoratorType<?> m_6663_() {
            return null;
        }
    }

    public static class MultiFolliageStraightTrunkPlacer
    extends TrunkPlacer {
        final int folliageDistance;
        final int maxBlobs;

        public MultiFolliageStraightTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, int folliageDistance, int maxBlobs) {
            super(baseHeight, heightRandA, heightRandB);
            this.folliageDistance = folliageDistance;
            this.maxBlobs = maxBlobs;
        }

        public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader p_226147_, BiConsumer<BlockPos, BlockState> p_226148_, RandomSource p_226149_, int p_226150_, BlockPos p_226151_, TreeConfiguration p_226152_) {
            MultiFolliageStraightTrunkPlacer.m_226169_((LevelSimulatedReader)p_226147_, p_226148_, (RandomSource)p_226149_, (BlockPos)p_226151_.m_7495_(), (TreeConfiguration)p_226152_);
            ArrayList<BlockPos> folliagePositions = new ArrayList<BlockPos>();
            int placed = 0;
            int j = 0;
            for (int i = p_226150_; i >= 0; --i) {
                BlockPos target = p_226151_.m_6630_(i);
                this.m_226187_(p_226147_, p_226148_, p_226149_, target, p_226152_);
                if (placed >= this.maxBlobs) continue;
                if (j == 0) {
                    folliagePositions.add(target);
                    j = this.folliageDistance;
                    ++placed;
                    continue;
                }
                --j;
            }
            return folliagePositions.stream().map(p -> new FoliagePlacer.FoliageAttachment(p, 0, false)).collect(Collectors.toList());
        }

        protected TrunkPlacerType<?> m_7362_() {
            return null;
        }
    }
}

