/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.aurelienribon.tweenengine.Tween;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.handler.ContributorRewardHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.RequestEmoteMessage;
import vazkii.quark.content.tweaks.client.emote.CustomEmoteIconResourcePack;
import vazkii.quark.content.tweaks.client.emote.EmoteBase;
import vazkii.quark.content.tweaks.client.emote.EmoteDescriptor;
import vazkii.quark.content.tweaks.client.emote.EmoteHandler;
import vazkii.quark.content.tweaks.client.emote.ModelAccessor;
import vazkii.quark.content.tweaks.client.screen.widgets.EmoteButton;
import vazkii.quark.content.tweaks.client.screen.widgets.TranslucentButton;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class EmotesModule
extends QuarkModule {
    private static final Set<String> DEFAULT_EMOTE_NAMES = ImmutableSet.of((Object)"no", (Object)"yes", (Object)"wave", (Object)"salute", (Object)"cheer", (Object)"clap", (Object[])new String[]{"think", "point", "shrug", "headbang", "weep", "facepalm"});
    private static final Set<String> PATREON_EMOTES = ImmutableSet.of((Object)"dance", (Object)"tpose", (Object)"dab", (Object)"jet", (Object)"exorcist", (Object)"zombie", (Object[])new String[0]);
    public static final int EMOTE_BUTTON_WIDTH = 25;
    public static final int EMOTES_PER_ROW = 3;
    @Config(description="The enabled default emotes. Remove from this list to disable them. You can also re-order them, if you feel like it.")
    public static List<String> enabledEmotes = Lists.newArrayList(DEFAULT_EMOTE_NAMES);
    @Config(description="The list of Custom Emotes to be loaded.\nWatch the tutorial on Custom Emotes to learn how to make your own: https://youtu.be/ourHUkan6aQ")
    public static List<String> customEmotes = Lists.newArrayList();
    @Config(description="Enable this to make custom emotes read the file every time they're triggered so you can edit on the fly.\nDO NOT ship enabled this in a modpack, please.")
    public static boolean customEmoteDebug = false;
    @Config
    public static int buttonShiftX = 0;
    @Config
    public static int buttonShiftY = 0;
    public static boolean emotesVisible = false;
    public static File emotesDir;
    @OnlyIn(value=Dist.CLIENT)
    public static CustomEmoteIconResourcePack resourcePack;
    @OnlyIn(value=Dist.CLIENT)
    private static Map<KeyMapping, String> emoteKeybinds;

    @Override
    public void constructClient() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        emotesDir = new File(mc.f_91069_, "/config/quark_emotes");
        if (!emotesDir.exists()) {
            emotesDir.mkdirs();
        }
        mc.m_91099_().addPackFinder(new RepositorySource(){

            public void m_7686_(@Nonnull Consumer<Pack> packConsumer, @Nonnull Pack.PackConstructor packInfoFactory) {
                resourcePack = new CustomEmoteIconResourcePack();
                String name = "quark:emote_resources";
                Pack t = Pack.m_10430_((String)name, (boolean)true, () -> resourcePack, (Pack.PackConstructor)packInfoFactory, (Pack.Position)Pack.Position.TOP, tx -> tx);
                packConsumer.accept(t);
            }
        });
    }

    @Override
    public void clientSetup() {
        Tween.registerAccessor(HumanoidModel.class, ModelAccessor.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerKeybinds(RegisterKeyMappingsEvent event) {
        int sortOrder = 0;
        emoteKeybinds = new HashMap<KeyMapping, String>();
        for (String s : DEFAULT_EMOTE_NAMES) {
            emoteKeybinds.put(ModKeybindHandler.init(event, "quark.emote." + s, null, "", "quark.gui.keygroup.emote", sortOrder++, false), s);
        }
        for (String s : PATREON_EMOTES) {
            emoteKeybinds.put(ModKeybindHandler.init(event, "patreon_emote." + s, null, "quark.gui.keygroup.emote", sortOrder++), s);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void configChangedClient() {
        EmoteHandler.clearEmotes();
        for (String s : enabledEmotes) {
            if (!DEFAULT_EMOTE_NAMES.contains(s)) continue;
            EmoteHandler.addEmote(s);
        }
        for (String s : PATREON_EMOTES) {
            EmoteHandler.addEmote(s);
        }
        for (String s : customEmotes) {
            EmoteHandler.addCustomEmote(s);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void initGui(ScreenEvent.Init.Post event) {
        Screen gui = event.getScreen();
        if (gui instanceof ChatScreen) {
            TreeMap<Integer, List> descriptorSorting = new TreeMap<Integer, List>();
            for (EmoteDescriptor desc : EmoteHandler.emoteMap.values()) {
                if (desc.getTier() > ContributorRewardHandler.localPatronTier) continue;
                List descriptors = descriptorSorting.computeIfAbsent(desc.getTier(), k -> new LinkedList());
                descriptors.add(desc);
            }
            int rows = 0;
            int row = 0;
            Minecraft mc = Minecraft.m_91087_();
            boolean expandDown = (Boolean)mc.f_91066_.m_231825_().m_231551_();
            Set keys = descriptorSorting.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                int tier = (Integer)iterator.next();
                List descriptors = (List)descriptorSorting.get(tier);
                if (descriptors == null) continue;
                rows += descriptors.size() / 3;
                if (descriptors.size() % 3 == 0) continue;
                ++rows;
            }
            int buttonX = buttonShiftX;
            int buttonY = (expandDown ? 2 : gui.f_96544_ - 40) + buttonShiftY;
            LinkedList<EmoteButton> emoteButtons = new LinkedList<EmoteButton>();
            Iterator iterator2 = keys.iterator();
            while (iterator2.hasNext()) {
                int tier = (Integer)iterator2.next();
                int rowPos = 0;
                int tierRow = 0;
                List descriptors = (List)descriptorSorting.get(tier);
                if (descriptors != null) {
                    for (EmoteDescriptor desc : descriptors) {
                        int rowSize = Math.min(descriptors.size() - tierRow * 3, 3);
                        int x = buttonX + gui.f_96543_ - 100 + (((rowPos + 1) * 2 + 3 - rowSize) * 25 / 2 + 1);
                        int y = buttonY + 25 * (rows - row) * (expandDown ? 1 : -1);
                        EmoteButton button = new EmoteButton(x, y, desc, b -> {
                            String name = desc.getRegistryName();
                            QuarkNetwork.sendToServer(new RequestEmoteMessage(name));
                        });
                        emoteButtons.add(button);
                        button.f_93624_ = emotesVisible;
                        button.f_93623_ = emotesVisible;
                        event.addListener((GuiEventListener)button);
                        if (++rowPos != 3) continue;
                        ++tierRow;
                        ++row;
                        rowPos = 0;
                    }
                }
                if (rowPos == 0) continue;
                ++row;
            }
            event.addListener((GuiEventListener)new TranslucentButton(buttonX + gui.f_96543_ - 1 - 75, buttonY, 75, 20, (Component)Component.m_237115_((String)"quark.gui.button.emotes"), b -> {
                for (Button bt : emoteButtons) {
                    if (!(bt instanceof EmoteButton)) continue;
                    bt.f_93624_ = !bt.f_93624_;
                    bt.f_93623_ = !bt.f_93623_;
                }
                emotesVisible = !emotesVisible;
            }));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91302_()) {
            for (KeyMapping key : emoteKeybinds.keySet()) {
                if (!key.m_90857_()) continue;
                String emote = emoteKeybinds.get(key);
                QuarkNetwork.sendToServer(new RequestEmoteMessage(emote));
                return;
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type()) {
            Minecraft mc = Minecraft.m_91087_();
            Window res = event.getWindow();
            PoseStack stack = event.getPoseStack();
            EmoteBase emote = EmoteHandler.getPlayerEmote((Player)mc.f_91074_);
            if (emote != null && emote.timeDone < emote.totalTime) {
                ResourceLocation resource = emote.desc.texture;
                int x = res.m_85445_() / 2 - 16;
                int y = res.m_85446_() / 2 - 60;
                float transparency = 1.0f;
                float tween = 5.0f;
                if (emote.timeDone < tween) {
                    transparency = emote.timeDone / tween;
                } else if (emote.timeDone > emote.totalTime - tween) {
                    transparency = (emote.totalTime - emote.timeDone) / tween;
                }
                stack.m_85836_();
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                Screen.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                RenderSystem.m_69478_();
                String name = I18n.m_118938_((String)emote.desc.getTranslationKey(), (Object[])new Object[0]);
                mc.f_91062_.m_92750_(stack, name, (float)res.m_85445_() / 2.0f - (float)mc.f_91062_.m_92895_(name) / 2.0f, (float)(y + 34), 0xFFFFFF + ((int)(transparency * 255.0f) << 24));
                stack.m_85849_();
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        EmoteHandler.onRenderTick(Minecraft.m_91087_());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public void preRenderLiving(RenderLivingEvent.Pre<Player, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            EmoteHandler.preRender(event.getPoseStack(), player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void postRenderLiving(RenderLivingEvent.Post<Player, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            EmoteHandler.postRender(event.getPoseStack(), player);
        }
    }
}

