/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.inputtable.ConvulsionMatrixConfig;
import vazkii.quark.mixin.client.accessor.AccessorBlockColors;

@LoadModule(category=ModuleCategory.CLIENT)
public class GreenerGrassModule
extends QuarkModule {
    private static final String[] GRASS_PRESET_NAMES = new String[]{"Dreary", "Vibrant"};
    private static final String GRASS_NAME = "Grass Colors";
    private static final String[] GRASS_BIOMES = new String[]{"plains", "forest", "mountains", "jungle", "savanna", "swamp"};
    private static final int[] GRASS_COLORS = new int[]{-7226023, -8798118, -7686519, -10892996, -4212907, -9801671};
    private static final int[] FOLLIAGE_COLORS = new int[]{-8934609, -10899920, -9591957, -13583605, -5331926, -9801671};
    private static final double[][] GRASS_PRESETS = new double[][]{{1.24, 0.0, 0.0, 0.0, 0.84, 0.0, 0.0, 0.16, 0.36}, {1.0, 0.0, 0.0, 0.24, 1.0, 0.24, 0.0, 0.0, 0.6}};
    private static final double[] GRASS_DEFAULT = new double[]{0.89, 0.0, 0.0, 0.0, 1.11, 0.0, 0.0, 0.0, 0.89};
    private static final String[] WATER_PRESET_NAMES = new String[]{"Muddy", "Colder"};
    private static final String WATER_NAME = "Water Colors";
    private static final String[] WATER_BIOMES = new String[]{"generic", "swamp", "meadow", "mangrove", "cold", "warm"};
    private static final int[] WATER_COLORS = new int[]{-12618012, -10388636, -15839537, -12944790, -12757034, -12331538};
    private static final double[][] WATER_PRESETS = new double[][]{{0.76, 0.0, 0.1, 0.0, 0.8, 0.0, 0.0, 0.0, 0.7}, {1.0, 0.0, 0.0, 0.24, 0.96, 0.24, 0.2, 0.52, 1.0}};
    private static final double[] WATER_DEFAULT = new double[]{0.86, 0.0, 0.0, 0.0, 1.0, 0.22, 0.0, 0.0, 1.22};
    private static ConvulsionMatrixConfig.Params GRASS_PARAMS = new ConvulsionMatrixConfig.Params("Grass Colors", GRASS_DEFAULT, GRASS_BIOMES, GRASS_COLORS, FOLLIAGE_COLORS, GRASS_PRESET_NAMES, GRASS_PRESETS);
    private static ConvulsionMatrixConfig.Params WATER_PARAMS = new ConvulsionMatrixConfig.Params("Water Colors", WATER_DEFAULT, WATER_BIOMES, WATER_COLORS, null, WATER_PRESET_NAMES, WATER_PRESETS);
    private static boolean staticEnabled = false;
    @Config
    public static boolean affectLeaves = true;
    @Config
    public static boolean affectWater = false;
    @Config
    public static List<String> blockList = Lists.newArrayList((Object[])new String[]{"minecraft:large_fern", "minecraft:tall_grass", "minecraft:grass_block", "minecraft:fern", "minecraft:grass", "minecraft:potted_fern", "minecraft:sugar_cane", "environmental:giant_tall_grass", "valhelsia_structures:grass_block"});
    @Config
    public static List<String> leavesList = Lists.newArrayList((Object[])new String[]{"minecraft:spruce_leaves", "minecraft:birch_leaves", "minecraft:oak_leaves", "minecraft:jungle_leaves", "minecraft:acacia_leaves", "minecraft:dark_oak_leaves", "atmospheric:rosewood_leaves", "atmospheric:morado_leaves", "atmospheric:yucca_leaves", "autumnity:maple_leaves", "environmental:willow_leaves", "environmental:hanging_willow_leaves", "minecraft:vine"});
    @Config
    public static ConvulsionMatrixConfig colorMatrix = new ConvulsionMatrixConfig(GRASS_PARAMS);
    @Config
    public static ConvulsionMatrixConfig waterMatrix = new ConvulsionMatrixConfig(WATER_PARAMS);

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    @Override
    public void firstClientTick() {
        this.registerGreenerColor(blockList, colorMatrix, (Supplier<Boolean>)((Supplier)() -> true));
        this.registerGreenerColor(leavesList, colorMatrix, (Supplier<Boolean>)((Supplier)() -> affectLeaves));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerGreenerColor(Iterable<String> ids, ConvulsionMatrixConfig config, Supplier<Boolean> condition) {
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        Map<Holder.Reference<Block>, BlockColor> map = ((AccessorBlockColors)colors).quark$getBlockColors();
        for (String id : ids) {
            Holder.Reference delegate;
            BlockColor color;
            Optional optDelegate;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
            if (block == null || (optDelegate = ForgeRegistries.BLOCKS.getDelegate((Object)block)) == null || !optDelegate.isPresent() || (color = map.get(delegate = (Holder.Reference)optDelegate.get())) == null) continue;
            colors.m_92589_(this.getConvulsedColor(config, color, condition), new Block[]{block});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private BlockColor getConvulsedColor(ConvulsionMatrixConfig config, BlockColor color, Supplier<Boolean> condition) {
        return (state, world, pos, tintIndex) -> {
            int originalColor = color.m_92566_(state, world, pos, tintIndex);
            if (!this.enabled || !((Boolean)condition.get()).booleanValue()) {
                return originalColor;
            }
            return colorMatrix.convolve(originalColor);
        };
    }

    public static int getWaterColor(int currColor) {
        if (!staticEnabled || !affectWater) {
            return currColor;
        }
        return waterMatrix.convolve(currColor);
    }
}

