/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.arl.util.ItemNBTHelper;

public class DataMaintainingSmeltingRecipe
extends SmeltingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final AbstractCookingRecipe parent;
    private final Ingredient pullDataFrom;

    public DataMaintainingSmeltingRecipe(AbstractCookingRecipe parent, Ingredient pullDataFrom) {
        super(parent.m_6423_(), parent.m_6076_(), (Ingredient)parent.m_7527_().get(0), parent.m_8043_(), parent.m_43750_(), parent.m_43753_());
        this.parent = parent;
        this.pullDataFrom = pullDataFrom;
    }

    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        return this.parent.m_5818_(inv, level);
    }

    public float m_43750_() {
        return this.parent.m_43750_();
    }

    public int m_43753_() {
        return this.parent.m_43753_();
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container inv) {
        ItemStack stack = this.parent.m_5874_(inv);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack inInv = inv.m_8020_(i);
            if (!this.pullDataFrom.test(inInv)) continue;
            CompoundTag tag = ItemNBTHelper.getNBT((ItemStack)inInv);
            if (tag.m_128456_()) break;
            stack.m_41784_().m_128391_(tag);
            break;
        }
        return stack;
    }

    public boolean m_8004_(int width, int height) {
        return this.parent.m_8004_(width, height);
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.parent.m_8043_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.parent.m_6423_();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return this.parent.m_6671_();
    }

    @Nonnull
    public NonNullList<ItemStack> m_7457_(@Nonnull Container inv) {
        return this.parent.m_7457_(inv);
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.parent.m_7527_();
    }

    public boolean m_5598_() {
        return this.parent.m_5598_();
    }

    @Nonnull
    public String m_6076_() {
        return this.parent.m_6076_();
    }

    @Nonnull
    public ItemStack m_8042_() {
        return this.parent.m_8042_();
    }

    public static class Serializer
    implements RecipeSerializer<DataMaintainingSmeltingRecipe> {
        @Nonnull
        public DataMaintainingSmeltingRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            String trueType = "minecraft:smelting";
            Ingredient pullFrom = Ingredient.m_43917_((JsonElement)json.get("copy_data_from"));
            RecipeSerializer serializer = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation(trueType));
            if (serializer == null) {
                throw new JsonSyntaxException("Invalid or unsupported recipe type '" + trueType + "'");
            }
            Recipe parent = serializer.m_6729_(recipeId, json);
            if (!(parent instanceof AbstractCookingRecipe)) {
                throw new JsonSyntaxException("Type '" + trueType + "' is not a cooking recipe");
            }
            AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)parent;
            return new DataMaintainingSmeltingRecipe(cookingRecipe, pullFrom);
        }

        @Nonnull
        public DataMaintainingSmeltingRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient pullFrom = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            String trueType = "minecraft:smelting";
            RecipeSerializer serializer = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation(trueType));
            if (serializer == null) {
                throw new IllegalArgumentException("Invalid or unsupported recipe type '" + trueType + "'");
            }
            Recipe parent = serializer.m_8005_(recipeId, buffer);
            if (!(parent instanceof AbstractCookingRecipe)) {
                throw new IllegalArgumentException("Type '" + trueType + "' is not a cooking recipe");
            }
            AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)parent;
            return new DataMaintainingSmeltingRecipe(cookingRecipe, pullFrom);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull DataMaintainingSmeltingRecipe recipe) {
            recipe.pullDataFrom.m_43923_(buffer);
            recipe.parent.m_7707_().m_6178_(buffer, (Recipe)recipe.parent);
        }
    }
}

