/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler.advancement.mod;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BredAnimalsTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.api.IMutableAdvancement;
import vazkii.quark.base.handler.advancement.AdvancementModifier;
import vazkii.quark.base.module.QuarkModule;

public class TwoByTwoModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET = new ResourceLocation("husbandry/bred_all_animals");
    final Set<EntityType<?>> entityTypes;

    public TwoByTwoModifier(QuarkModule module, Set<EntityType<?>> entityTypes) {
        super(module);
        this.entityTypes = entityTypes;
        Preconditions.checkArgument((!entityTypes.isEmpty() ? 1 : 0) != 0, (Object)"Advancement modifier list cant be empty");
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv) {
        for (EntityType<?> type : this.entityTypes) {
            Criterion criterion = new Criterion((CriterionTriggerInstance)BredAnimalsTrigger.TriggerInstance.m_18667_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_(type))));
            String name = ForgeRegistries.ENTITY_TYPES.getKey(type).toString();
            adv.addRequiredCriterion(name, criterion);
        }
        return true;
    }
}

