/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.addons.oddities.inventory.BackpackMenu;
import vazkii.quark.addons.oddities.module.BackpackModule;
import vazkii.quark.base.client.handler.ModelHandler;
import vazkii.quark.base.client.handler.RequiredModTooltipHandler;
import vazkii.quark.base.handler.ProxiedItemStackHandler;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.QuarkModule;

public class BackpackItem
extends DyeableArmorItem
implements IQuarkItem,
IItemColorProvider,
MenuProvider {
    private static final String WORN_TEXTURE = "quark:textures/misc/backpack_worn.png";
    private static final String WORN_OVERLAY_TEXTURE = "quark:textures/misc/backpack_worn_overlay.png";
    private final QuarkModule module;
    @OnlyIn(value=Dist.CLIENT)
    private HumanoidModel model;

    public BackpackItem(QuarkModule module) {
        super((ArmorMaterial)ArmorMaterials.LEATHER, EquipmentSlot.CHEST, new Item.Properties().m_41487_(1).m_41503_(0).m_41491_(CreativeModeTab.f_40756_).m_41497_(Rarity.RARE));
        RegistryHelper.registerItem((Item)this, (String)"backpack");
        this.module = module;
        if (module.category.isAddon()) {
            RequiredModTooltipHandler.map((Item)this, module.category.requiredMod);
        }
    }

    public int getDefaultTooltipHideFlags(@Nonnull ItemStack stack) {
        return stack.m_41793_() ? ItemStack.TooltipPart.ENCHANTMENTS.m_41809_() : 0;
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    public static boolean doesBackpackHaveItems(ItemStack stack) {
        LazyOptional handlerOpt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        if (!handlerOpt.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)handlerOpt.orElse((Object)new ItemStackHandler());
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean m_41465_() {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public void m_6883_(@Nonnull ItemStack stack, Level worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean hasItems = !BackpackModule.superOpMode && BackpackItem.doesBackpackHaveItems(stack);
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        boolean isCursed = enchants.containsKey(Enchantments.f_44975_);
        boolean changedEnchants = false;
        if (hasItems) {
            if (BackpackModule.isEntityWearingBackpack(entityIn, stack)) {
                if (!isCursed) {
                    enchants.put(Enchantments.f_44975_, 1);
                    changedEnchants = true;
                }
                if (BackpackModule.itemsInBackpackTick) {
                    LazyOptional handlerOpt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                    IItemHandler handler = (IItemHandler)handlerOpt.orElse((Object)new ItemStackHandler());
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack inStack = handler.getStackInSlot(i);
                        if (inStack.m_41619_()) continue;
                        inStack.m_41720_().m_6883_(inStack, worldIn, entityIn, i, false);
                    }
                }
            } else {
                ItemStack copy = stack.m_41777_();
                stack.m_41764_(0);
                entityIn.m_5552_(copy, 0.0f);
            }
        } else if (isCursed) {
            enchants.remove(Enchantments.f_44975_);
            changedEnchants = true;
        }
        if (changedEnchants) {
            EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)stack);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        if (BackpackModule.superOpMode || entityItem.f_19853_.f_46443_) {
            return false;
        }
        if (!ItemNBTHelper.detectNBT((ItemStack)stack)) {
            return false;
        }
        LazyOptional handlerOpt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        if (!handlerOpt.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)handlerOpt.orElse((Object)new ItemStackHandler());
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            if (stackAt.m_41619_()) continue;
            ItemStack copy = stackAt.m_41777_();
            Containers.m_18992_((Level)entityItem.f_19853_, (double)entityItem.m_20185_(), (double)entityItem.m_20186_(), (double)entityItem.m_20189_(), (ItemStack)copy);
        }
        CompoundTag comp = ItemNBTHelper.getNBT((ItemStack)stack);
        comp.m_128473_("Inventory");
        if (comp.m_128440_() == 0) {
            stack.m_41751_(null);
        }
        return false;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag oldCapNbt) {
        ProxiedItemStackHandler handler = new ProxiedItemStackHandler(stack, 27);
        if (oldCapNbt != null && oldCapNbt.m_128441_("Parent")) {
            CompoundTag itemData = oldCapNbt.m_128469_("Parent");
            ItemStackHandler stacks = new ItemStackHandler();
            stacks.deserializeNBT(itemData);
            for (int i = 0; i < stacks.getSlots(); ++i) {
                handler.setStackInSlot(i, stacks.getStackInSlot(i));
            }
            oldCapNbt.m_128473_("Parent");
        }
        return handler;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return type != null && type.equals("overlay") ? WORN_OVERLAY_TEXTURE : WORN_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return ModelHandler.armorModel(ModelHandler.backpack, armorSlot);
            }
        });
    }

    public boolean m_5812_(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_6787_(group, items);
        }
    }

    public ItemColor getItemColor() {
        return (stack, i) -> i > 0 ? -1 : ((DyeableArmorItem)stack.m_41720_()).m_41121_(stack);
    }

    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new BackpackMenu(id, player);
    }

    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_5524_());
    }
}

