/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ConfigDataHolder;
import java.nio.file.Paths;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public interface ConfigHolder {
    public <T extends ConfigCore> ConfigDataHolder<T> getHolder(Class<T> var1);

    default public <T extends ConfigCore> T get(Class<T> clazz) {
        return this.getHolder(clazz).config();
    }

    public void bakeConfigs(String var1);

    public static String simpleName(String modId) {
        return String.format("%s.toml", modId);
    }

    public static String defaultName(String modId, String type) {
        return String.format("%s-%s.toml", modId, type);
    }

    public static String moveToDir(String configDir, String fileName) {
        return Paths.get(configDir, fileName).toString();
    }

    public static interface Builder
    extends ConfigHolder {
        public <T extends ConfigCore> Builder clientConfig(Class<T> var1, Supplier<T> var2);

        public <T extends ConfigCore> Builder commonConfig(Class<T> var1, Supplier<T> var2);

        public <T extends ConfigCore> Builder serverConfig(Class<T> var1, Supplier<T> var2);

        public <T extends ConfigCore> Builder setFileName(Class<T> var1, UnaryOperator<String> var2);
    }
}

