/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryEvent<T>
extends GenericEvent<T>
implements IModBusEvent {
    RegistryEvent(Class<T> clazz) {
        super(clazz);
    }

    public static class RegistryWrapper<T> {
        private final IForgeRegistry<T> reg;

        public RegistryWrapper(IForgeRegistry<T> reg) {
            this.reg = reg;
        }

        public void register(T object, String id) {
            this.reg.register(id, object);
        }

        public void register(T object, ResourceLocation id) {
            this.reg.register(id, object);
        }

        public void registerAll(Object ... arr) {
            for (int i = 0; i < arr.length; i += 2) {
                Object object = arr[i];
                Object id = arr[i + 1];
                if (id instanceof String) {
                    String s = (String)id;
                    this.reg.register(s, object);
                    continue;
                }
                if (id instanceof ResourceLocation) {
                    ResourceLocation r = (ResourceLocation)id;
                    this.reg.register(r, object);
                    continue;
                }
                throw new RuntimeException();
            }
        }
    }

    public static class Register<T>
    extends RegistryEvent<T> {
        private final IForgeRegistry<T> registry;
        private final ResourceLocation name;
        private final RegistryWrapper<T> wrapper;

        public Register(Class<T> clazz, IForgeRegistry<T> registry) {
            super(clazz);
            this.name = registry.getRegistryKey().m_135782_();
            this.registry = registry;
            this.wrapper = new RegistryWrapper<T>(registry);
        }

        public RegistryWrapper<T> getRegistry() {
            return this.wrapper;
        }

        public IForgeRegistry<T> getForgeRegistry() {
            return this.registry;
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public String toString() {
            return "RegistryEvent.Register<" + this.getName() + ">";
        }
    }
}

