/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.patreon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import shadows.placebo.Placebo;
import shadows.placebo.packets.PatreonDisableMessage;
import shadows.placebo.patreon.PatreonUtils;
import shadows.placebo.patreon.wings.Wing;
import shadows.placebo.patreon.wings.WingLayer;

public class WingsManager {
    static Map<UUID, PatreonUtils.WingType> WINGS = new HashMap<UUID, PatreonUtils.WingType>();
    public static final KeyMapping TOGGLE = new KeyMapping("placebo.toggleWings", 328, "key.categories.placebo");
    public static final Set<UUID> DISABLED = new HashSet<UUID>();
    public static final ModelLayerLocation WING_LOC = new ModelLayerLocation(new ResourceLocation("placebo", "wings"), "main");

    public static void init(FMLClientSetupEvent e) {
        e.enqueueWork(() -> ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)WING_LOC, Wing::createLayer));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(WingsManager::addLayers);
        new Thread(() -> {
            Placebo.LOGGER.info("Loading patreon wing data...");
            try {
                URL url = new URL("https://raw.githubusercontent.com/Shadows-of-Fire/Placebo/1.16/PatreonWings.txt");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String s;
                    while ((s = reader.readLine()) != null) {
                        String[] split = s.split(" ", 2);
                        if (split.length != 2) {
                            Placebo.LOGGER.error("Invalid patreon wing entry {} will be ignored.", (Object)s);
                            continue;
                        }
                        WINGS.put(UUID.fromString(split[0]), PatreonUtils.WingType.valueOf(split[1]));
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    Placebo.LOGGER.error("Exception loading patreon wing data!");
                    ex.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Placebo.LOGGER.info("Loaded {} patreon wings.", (Object)WINGS.size());
            if (WINGS.size() > 0) {
                MinecraftForge.EVENT_BUS.register(WingsManager.class);
            }
        }, "Placebo Patreon Wing Loader").start();
    }

    @SubscribeEvent
    public static void keys(InputEvent.Key e) {
        if (e.getAction() == 1 && TOGGLE.m_90832_(e.getKey(), e.getScanCode()) && Minecraft.m_91087_().m_91403_() != null) {
            Placebo.CHANNEL.sendToServer((Object)new PatreonDisableMessage(1));
        }
    }

    public static void addLayers(EntityRenderersEvent.AddLayers e) {
        Wing.INSTANCE = new Wing(e.getEntityModels().m_171103_(WING_LOC));
        for (String s : e.getSkins()) {
            LivingEntityRenderer skin = e.getSkin(s);
            skin.m_115326_((RenderLayer)new WingLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)skin));
        }
    }

    public static PatreonUtils.WingType getType(UUID id) {
        return WINGS.get(id);
    }
}

