/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.loot;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.placebo.Placebo;
import shadows.placebo.loot.PoolBuilder;
import shadows.placebo.loot.StackLootEntry;

public class LootSystem {
    public static final Map<ResourceLocation, LootTable> PLACEBO_TABLES = new HashMap<ResourceLocation, LootTable>();

    public static void registerLootTable(ResourceLocation key, LootTable table) {
        if (!PLACEBO_TABLES.containsKey(key)) {
            table.setLootTableId(key);
            PLACEBO_TABLES.put(key, table);
        } else {
            Placebo.LOGGER.warn("Duplicate loot entry detected, this is not allowed!  Key: " + key);
        }
    }

    public static LootTable.Builder tableBuilder() {
        return new LootTable.Builder();
    }

    public static PoolBuilder poolBuilder(int minRolls, int maxRolls) {
        return new PoolBuilder(minRolls, maxRolls);
    }

    public static void defaultBlockTable(Block b) {
        LootTable.Builder builder = LootSystem.tableBuilder();
        builder.m_79161_(LootSystem.poolBuilder(1, 1).addEntries(new LootPoolEntryContainer[]{new StackLootEntry(new ItemStack((ItemLike)b))}).m_79080_(ExplosionCondition.m_81661_()));
        LootSystem.registerLootTable(new ResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)b).m_135827_(), "blocks/" + ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_()), builder.m_79167_());
    }
}

