/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonEntry
extends Button {
    private static final int ANIM_TIME = 5;
    private final GuiBook parent;
    private final BookEntry entry;
    private float timeHovered;

    public GuiButtonEntry(GuiBook parent, int x, int y, BookEntry entry, Button.OnPress onPress) {
        super(x, y, 116, 10, (Component)entry.getName(), onPress);
        this.parent = parent;
        this.entry = entry;
    }

    public void m_6303_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93623_) {
            MutableComponent name;
            this.timeHovered = this.m_198029_() ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.m_198029_() ? partialTicks : -partialTicks)));
            float widthFract = time / 5.0f;
            boolean locked = this.entry.isLocked();
            ms.m_85841_(0.5f, 0.5f, 0.5f);
            GuiComponent.m_93172_((PoseStack)ms, (int)(this.f_93620_ * 2), (int)(this.f_93621_ * 2), (int)((this.f_93620_ + (int)((float)this.f_93618_ * widthFract)) * 2), (int)((this.f_93621_ + this.f_93619_) * 2), (int)0x22000000);
            RenderSystem.m_69478_();
            if (locked) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                GuiBook.drawLock(ms, this.parent.book, this.f_93620_ * 2 + 2, this.f_93621_ * 2 + 2);
            } else {
                this.entry.getIcon().render(ms, this.f_93620_ * 2 + 2, this.f_93621_ * 2 + 2);
            }
            ms.m_85841_(2.0f, 2.0f, 2.0f);
            if (locked) {
                name = Component.m_237115_((String)"patchouli.gui.lexicon.locked");
            } else {
                name = this.entry.getName();
                if (this.entry.isPriority()) {
                    name = name.m_130940_(ChatFormatting.ITALIC);
                }
            }
            name = name.m_130948_(this.entry.getBook().getFontStyle());
            Minecraft.m_91087_().f_91062_.m_92889_(ms, (Component)name, (float)(this.f_93620_ + 12), (float)this.f_93621_, this.getColor());
            if (!this.entry.isLocked()) {
                GuiBook.drawMarking(ms, this.parent.book, this.f_93620_ + this.f_93618_ - 5, this.f_93621_ + 1, this.entry.hashCode(), this.entry.getReadState());
            }
        }
    }

    private int getColor() {
        if (this.entry.isSecret()) {
            return 0xAA000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        if (this.entry.isLocked()) {
            return 0x77000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        return this.entry.getEntryColor();
    }

    public void m_7435_(SoundManager soundHandlerIn) {
        if (this.entry != null && !this.entry.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookEntry getEntry() {
        return this.entry;
    }
}

