/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.morphtool.ConfigHandler;
import vazkii.morphtool.ModItems;

public final class MorphingHandler {
    public static final MorphingHandler INSTANCE = new MorphingHandler();
    public static final String MINECRAFT = "minecraft";
    public static final String TAG_MORPHING_TOOL = "morphtool:is_morphing";
    public static final String TAG_MORPH_TOOL_DATA = "morphtool:data";
    public static final String TAG_MORPH_TOOL_DISPLAY_NAME = "morphtool:displayName";
    private static final Map<String, String> modNames = new HashMap<String, String>();

    @SubscribeEvent
    public void onItemDropped(ItemTossEvent event) {
        if (!event.getPlayer().m_6047_()) {
            return;
        }
        ItemEntity e = event.getEntity();
        ItemStack stack = e.m_32055_();
        MorphingHandler.removeItemFromTool((Entity)e, stack, false, arg_0 -> ((ItemEntity)e).m_32045_(arg_0));
    }

    @SubscribeEvent
    public void onItemBroken(PlayerDestroyItemEvent event) {
        MorphingHandler.removeItemFromTool((Entity)event.getEntity(), event.getOriginal(), true, morph -> event.getEntity().m_21008_(event.getHand(), morph));
    }

    public static void removeItemFromTool(Entity e, ItemStack stack, boolean itemBroken, Consumer<ItemStack> consumer) {
        if (stack != null && !stack.m_41619_() && MorphingHandler.isMorphTool(stack) && stack.m_41720_() != ModItems.tool) {
            CompoundTag morphData = stack.m_41783_().m_128469_(TAG_MORPH_TOOL_DATA).m_6426_();
            ItemStack morph = MorphingHandler.makeMorphedStack(stack, MINECRAFT, morphData);
            CompoundTag newMorphData = morph.m_41783_().m_128469_(TAG_MORPH_TOOL_DATA);
            newMorphData.m_128473_(MorphingHandler.getModFromStack(stack));
            if (!itemBroken) {
                ItemStack copy;
                CompoundTag copyCmp;
                if (!e.m_20193_().f_46443_) {
                    ItemEntity newItem = new ItemEntity(e.m_20193_(), e.m_20185_(), e.m_20186_(), e.m_20189_(), morph);
                    e.m_20193_().m_7967_((Entity)newItem);
                }
                if ((copyCmp = (copy = stack.m_41777_()).m_41783_()) == null) {
                    copyCmp = new CompoundTag();
                    copy.m_41751_(copyCmp);
                }
                copyCmp.m_128473_("display");
                copyCmp.m_128473_(TAG_MORPHING_TOOL);
                copyCmp.m_128473_(TAG_MORPH_TOOL_DISPLAY_NAME);
                copyCmp.m_128473_(TAG_MORPH_TOOL_DATA);
                consumer.accept(copy);
            } else {
                consumer.accept(morph);
            }
        }
    }

    public static String getModFromState(BlockState state) {
        return MorphingHandler.getModOrAlias(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).m_135827_());
    }

    public static String getModFromStack(ItemStack stack) {
        String modId = stack.m_41720_().getCreatorModId(stack);
        return MorphingHandler.getModOrAlias(stack.m_41619_() ? MINECRAFT : (modId != null ? modId : MINECRAFT));
    }

    public static String getModOrAlias(String mod) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (String s : (List)ConfigHandler.aliasesList.get()) {
            if (!s.matches(".+?=.+")) continue;
            String[] tokens = s.toLowerCase().split("=");
            aliases.put(tokens[0], tokens[1]);
        }
        return aliases.getOrDefault(mod, mod);
    }

    public static ItemStack getShiftStackForMod(ItemStack stack, String mod) {
        if (!stack.m_41782_()) {
            return stack;
        }
        String currentMod = MorphingHandler.getModFromStack(stack);
        if (mod.equals(currentMod)) {
            return stack;
        }
        CompoundTag morphData = stack.m_41783_().m_128469_(TAG_MORPH_TOOL_DATA);
        return MorphingHandler.makeMorphedStack(stack, mod, morphData);
    }

    public static ItemStack makeMorphedStack(ItemStack currentStack, String targetMod, CompoundTag morphData) {
        ItemStack stack;
        String currentMod = MorphingHandler.getModFromStack(currentStack);
        CompoundTag currentCmp = new CompoundTag();
        currentStack.m_41739_(currentCmp);
        currentCmp = currentCmp.m_6426_();
        if (currentCmp.m_128441_("tag")) {
            currentCmp.m_128469_("tag").m_128473_(TAG_MORPH_TOOL_DATA);
        }
        if (!currentMod.equalsIgnoreCase(MINECRAFT) && !currentMod.equalsIgnoreCase("morphtool")) {
            morphData.m_128365_(currentMod, (Tag)currentCmp);
        }
        if (targetMod.equals(MINECRAFT)) {
            stack = new ItemStack((ItemLike)ModItems.tool);
        } else {
            CompoundTag targetCmp = morphData.m_128469_(targetMod);
            morphData.m_128473_(targetMod);
            stack = ItemStack.m_41712_((CompoundTag)targetCmp);
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)ModItems.tool);
            }
        }
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag stackCmp = stack.m_41783_();
        stackCmp.m_128365_(TAG_MORPH_TOOL_DATA, (Tag)morphData);
        stackCmp.m_128379_(TAG_MORPHING_TOOL, true);
        if (stack.m_41720_() != ModItems.tool) {
            CompoundTag displayName;
            CompoundTag ogDisplayName = displayName = new CompoundTag();
            displayName.m_128359_("text", Component.Serializer.m_130703_((Component)stack.m_41786_()));
            if (stackCmp.m_128441_(TAG_MORPH_TOOL_DISPLAY_NAME)) {
                displayName = (CompoundTag)stackCmp.m_128423_(TAG_MORPH_TOOL_DISPLAY_NAME);
            } else {
                stackCmp.m_128365_(TAG_MORPH_TOOL_DISPLAY_NAME, (Tag)displayName);
            }
            MutableComponent rawComp = Component.Serializer.m_130701_((String)displayName.m_128461_("text"));
            if (rawComp == null) {
                stackCmp.m_128365_(TAG_MORPH_TOOL_DISPLAY_NAME, (Tag)displayName);
                displayName = ogDisplayName;
            }
            MutableComponent stackName = rawComp.m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GREEN}));
            MutableComponent comp = Component.m_237110_((String)"morphtool.sudo_name", (Object[])new Object[]{stackName});
            stack.m_41714_((Component)comp);
        }
        stack.m_41764_(1);
        return stack;
    }

    public static String getModNameForId(String modId) {
        modId = modId.toLowerCase(Locale.ENGLISH);
        return modNames.getOrDefault(modId, modId);
    }

    public static boolean isMorphTool(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_41720_() == ModItems.tool) {
            return true;
        }
        return stack.m_41782_() && stack.m_41783_().m_128471_(TAG_MORPHING_TOOL);
    }

    public static HitResult raycast(Entity e, double len) {
        Vec3 look;
        Vec3 vec = new Vec3(e.m_20185_(), e.m_20186_(), e.m_20189_());
        if (e instanceof Player) {
            vec = vec.m_82549_(new Vec3(0.0, (double)e.m_20192_(), 0.0));
        }
        if ((look = e.m_20154_()) == null) {
            return null;
        }
        return MorphingHandler.raycast(e, vec, look, len);
    }

    public static HitResult raycast(Entity e, Vec3 origin, Vec3 ray, double len) {
        Vec3 end = origin.m_82549_(ray.m_82541_().m_82490_(len));
        return e.m_20193_().m_45547_(new ClipContext(origin, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, e));
    }

    static {
        for (IModInfo modEntry : ModList.get().getMods()) {
            modNames.put(modEntry.getModId().toLowerCase(Locale.ENGLISH), modEntry.getDisplayName());
        }
    }
}

