/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MultiblockTileEntityRenderer;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.WorldUtils;
import mekanism.generators.client.render.RenderTurbineRotor;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public class RenderIndustrialTurbine
extends MultiblockTileEntityRenderer<TurbineMultiblockData, TileEntityTurbineCasing> {
    public RenderIndustrialTurbine(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(TileEntityTurbineCasing tile, TurbineMultiblockData multiblock, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        int height;
        BlockPos pos = tile.m_58899_();
        profiler.m_6180_("turbineRotor");
        if (RenderTurbineRotor.INSTANCE != null) {
            BlockPos complexPos = multiblock.complex;
            VertexConsumer buffer = RenderTurbineRotor.INSTANCE.getBuffer(renderer);
            matrix.m_85836_();
            matrix.m_85837_((double)(complexPos.m_123341_() - pos.m_123341_()), (double)(complexPos.m_123342_() - pos.m_123342_()), (double)(complexPos.m_123343_() - pos.m_123343_()));
            while (true) {
                complexPos = complexPos.m_7495_();
                TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)WorldUtils.getTileEntity(TileEntityTurbineRotor.class, (BlockGetter)tile.m_58904_(), (BlockPos)complexPos);
                if (rotor == null) break;
                matrix.m_85837_(0.0, -1.0, 0.0);
                RenderTurbineRotor.INSTANCE.render(rotor, matrix, buffer, 0xF00000, overlayLight);
            }
            matrix.m_85849_();
        }
        profiler.m_7238_();
        if (!multiblock.gasTank.isEmpty() && multiblock.length() > 0 && (height = multiblock.lowerVolume / (multiblock.length() * multiblock.width())) > 0) {
            RenderData data = RenderData.Builder.create((ChemicalStack)multiblock.gasTank.getStack()).of((MultiblockData)multiblock).height(height).build();
            this.renderObject(data, pos, matrix, renderer.m_6299_(Sheets.m_110792_()), overlayLight, multiblock.prevSteamScale);
        }
    }

    protected String getProfilerSection() {
        return "industrialTurbine";
    }

    protected boolean shouldRender(TileEntityTurbineCasing tile, TurbineMultiblockData multiblock, Vec3 camera) {
        return super.shouldRender((TileEntityMultiblock)tile, (MultiblockData)multiblock, camera) && multiblock.complex != null;
    }
}

