/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.client.model.ModelEnergyCore;
import mekanism.client.render.tileentity.MultiblockTileEntityRenderer;
import mekanism.client.render.tileentity.RenderEnergyCube;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public class RenderFusionReactor
extends MultiblockTileEntityRenderer<FusionReactorMultiblockData, TileEntityFusionReactorController> {
    private static final double SCALE = 1.0E8;
    private final ModelEnergyCore core;

    public RenderFusionReactor(BlockEntityRendererProvider.Context context) {
        super(context);
        this.core = new ModelEnergyCore(context.m_173585_());
    }

    protected void render(TileEntityFusionReactorController tile, FusionReactorMultiblockData multiblock, float partialTicks, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        long scaledTemp = Math.round(multiblock.getLastPlasmaTemp() / 1.0E8);
        float ticks = (float)Minecraft.m_91087_().f_91060_.f_109477_ + partialTicks;
        float ticksScaledTemp = ticks * (float)scaledTemp;
        VertexConsumer buffer = renderer.m_6299_(this.core.RENDER_TYPE);
        matrix.m_85836_();
        matrix.m_85837_(0.5, -1.5, 0.5);
        float scale = 1.0f + 0.7f * RenderFusionReactor.sinDegrees(3.14f * ticksScaledTemp + 135.0f);
        this.renderPart(matrix, buffer, overlayLight, EnumColor.AQUA, scale, ticksScaledTemp, -6, -7, 0, 36);
        scale = 1.0f + 0.8f * RenderFusionReactor.sinDegrees(3.0f * ticksScaledTemp);
        this.renderPart(matrix, buffer, overlayLight, EnumColor.RED, scale, ticksScaledTemp, 4, 4, 0, 36);
        scale = 1.0f - 0.9f * RenderFusionReactor.sinDegrees(4.0f * ticksScaledTemp + 90.0f);
        this.renderPart(matrix, buffer, overlayLight, EnumColor.ORANGE, scale, ticksScaledTemp, 5, -3, -35, 106);
        matrix.m_85849_();
        this.endIfNeeded(renderer, this.core.RENDER_TYPE);
    }

    private static float sinDegrees(float degrees) {
        return Mth.m_14031_((float)(degrees % 360.0f * ((float)Math.PI / 180)));
    }

    protected String getProfilerSection() {
        return "fusionReactor";
    }

    private void renderPart(PoseStack matrix, VertexConsumer buffer, int overlayLight, EnumColor color, float scale, float ticksScaledTemp, int mult1, int mult2, int shift1, int shift2) {
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, scale);
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(ticksScaledTemp * (float)mult1 + (float)shift1));
        matrix.m_85845_(RenderEnergyCube.coreVec.m_122240_(ticksScaledTemp * (float)mult2 + (float)shift2));
        this.core.render(matrix, buffer, 0xF000F0, overlayLight, color, 1.0f);
        matrix.m_85849_();
    }

    protected boolean shouldRender(TileEntityFusionReactorController tile, FusionReactorMultiblockData multiblock, Vec3 camera) {
        return multiblock.isBurning();
    }
}

