/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import mekanism.common.registration.impl.SetupFeatureDeferredRegister;
import mekanism.common.registration.impl.SetupFeatureRegistryObject;
import mekanism.common.registries.MekanismFeatures;
import mekanism.common.world.ResizableOreFeature;
import mekanism.common.world.ResizableOreFeatureConfig;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;

public class GenHandler {
    private GenHandler() {
    }

    public static boolean generate(ServerLevel world, ChunkPos chunkPos) {
        boolean generated = false;
        if (!SharedConstants.m_183707_((ChunkPos)chunkPos)) {
            List list;
            SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)world.m_151560_());
            BlockPos blockPos = sectionPos.m_123249_();
            ChunkGenerator chunkGenerator = world.m_7726_().m_8481_();
            WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));
            long decorationSeed = random.m_64690_(world.m_7328_(), blockPos.m_123341_(), blockPos.m_123343_());
            int decorationStep = GenerationStep.Decoration.UNDERGROUND_ORES.ordinal() - 1;
            ToIntFunction featureIndex = decorationStep < (list = (List)chunkGenerator.f_223020_.get()).size() ? ((FeatureSorter.StepFeatureData)list.get(decorationStep)).f_220625_() : feature -> -1;
            for (SetupFeatureDeferredRegister.MekFeature<ResizableOreFeatureConfig, ResizableOreFeature>[] features : MekanismFeatures.ORES.values()) {
                for (SetupFeatureDeferredRegister.MekFeature<ResizableOreFeatureConfig, ResizableOreFeature> feature2 : features) {
                    generated |= GenHandler.place((WorldGenLevel)world, chunkGenerator, blockPos, random, decorationSeed, decorationStep, featureIndex, feature2);
                }
            }
            generated |= GenHandler.place((WorldGenLevel)world, chunkGenerator, blockPos, random, decorationSeed, decorationStep, featureIndex, MekanismFeatures.SALT);
            world.m_143497_(null);
        }
        return generated;
    }

    private static boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, BlockPos blockPos, WorldgenRandom random, long decorationSeed, int decorationStep, ToIntFunction<PlacedFeature> featureIndex, SetupFeatureDeferredRegister.MekFeature<?, ?> feature) {
        SetupFeatureRegistryObject<?, ?> retrogen = feature.retrogen();
        PlacedFeature baseFeature = feature.feature().getPlacedFeature();
        random.m_190064_(decorationSeed, featureIndex.applyAsInt(baseFeature), decorationStep);
        world.m_143497_(() -> retrogen.getPlacedFeatureKey().toString());
        return retrogen.getPlacedFeature().m_226368_(new PlacementContext(world, chunkGenerator, Optional.of(baseFeature)), (RandomSource)random, blockPos);
    }
}

