/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collections;
import java.util.List;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.fluid.DynamicFluidHandler;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.FluidHandlerManager;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityMechanicalPipe
extends TileEntityTransmitter
implements IComputerTile {
    private final FluidHandlerManager fluidHandlerManager = new FluidHandlerManager(direction -> {
        MechanicalPipe pipe = this.getTransmitter();
        if (direction != null && pipe.getConnectionTypeRaw(direction) == ConnectionType.NONE || pipe.isRedstoneActivated()) {
            return Collections.emptyList();
        }
        return pipe.getFluidTanks(direction);
    }, new DynamicFluidHandler(this::getFluidTanks, this.getExtractPredicate(), this.getInsertPredicate(), null));

    public TileEntityMechanicalPipe(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver(this.fluidHandlerManager);
        ComputerCapabilityHelper.addComputerCapabilities(this, x$0 -> this.addCapabilityResolver((ICapabilityResolver)x$0));
    }

    protected MechanicalPipe createTransmitter(IBlockProvider blockProvider) {
        return new MechanicalPipe(blockProvider, this);
    }

    public MechanicalPipe getTransmitter() {
        return (MechanicalPipe)super.getTransmitter();
    }

    @Override
    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.MECHANICAL_PIPE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull BaseTier tier) {
        return BlockStateHelper.copyStateData(current, switch (tier) {
            case BaseTier.BASIC -> MekanismBlocks.BASIC_MECHANICAL_PIPE;
            case BaseTier.ADVANCED -> MekanismBlocks.ADVANCED_MECHANICAL_PIPE;
            case BaseTier.ELITE -> MekanismBlocks.ELITE_MECHANICAL_PIPE;
            case BaseTier.ULTIMATE -> MekanismBlocks.ULTIMATE_MECHANICAL_PIPE;
            default -> null;
        });
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.m_128365_("fluid", (Tag)network.lastFluid.writeToNBT(new CompoundTag()));
            updateTag.m_128350_("scale", network.currentScale);
        }
        return updateTag;
    }

    private List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidHandlerManager.getContainers(side);
    }

    @Override
    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability((Capability<?>)ForgeCapabilities.FLUID_HANDLER, side);
            WorldUtils.notifyNeighborOfChange(this.f_58857_, side, this.f_58858_);
        } else if (old == ConnectionType.NONE) {
            WorldUtils.notifyNeighborOfChange(this.f_58857_, side, this.f_58858_);
        }
    }

    @Override
    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapability(ForgeCapabilities.FLUID_HANDLER, EnumUtils.DIRECTIONS);
        }
    }

    @Override
    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "MechanicalPipe";
    }

    @ComputerMethod
    private FluidStack getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    private long getCapacity() {
        MechanicalPipe pipe = this.getTransmitter();
        return pipe.hasTransmitterNetwork() ? ((FluidNetwork)pipe.getTransmitterNetwork()).getCapacity() : pipe.getCapacity();
    }

    @ComputerMethod
    private long getNeeded() {
        return this.getCapacity() - (long)this.getBuffer().getAmount();
    }

    @ComputerMethod
    private double getFilledPercentage() {
        return (double)this.getBuffer().getAmount() / (double)this.getCapacity();
    }
}

