/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MinerEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.SortableFilterManager;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableRegistryEntry;
import mekanism.common.inventory.container.tile.DigitalMinerConfigContainer;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IHasVisualization;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityDigitalMiner
extends TileEntityMekanism
implements ISustainedData,
IChunkLoader,
IBoundingBlock,
ITileFilterHolder<MinerFilter<?>>,
IHasVisualization {
    public static final int DEFAULT_HEIGHT_RANGE = 60;
    public static final int DEFAULT_RADIUS = 10;
    private final SortableFilterManager<MinerFilter<?>> filterManager = new SortableFilterManager<MinerFilter>(MinerFilter.class, this::markForSave);
    private Long2ObjectMap<BitSet> oresToMine = Long2ObjectMaps.emptyMap();
    public ThreadMinerSearch searcher = new ThreadMinerSearch(this);
    private int radius;
    private boolean inverse;
    private boolean inverseRequiresReplacement;
    private Item inverseReplaceTarget = Items.f_41852_;
    private int minY;
    private int maxY = this.minY + 60;
    private boolean doEject = false;
    private boolean doPull = false;
    public ItemStack missingStack = ItemStack.f_41583_;
    private final Predicate<ItemStack> overflowCollector = this::trackOverflow;
    private final Object2IntMap<HashedItem> overflow = new Object2IntLinkedOpenHashMap();
    private boolean hasOverflow;
    private boolean recheckOverflow;
    private int delay;
    private int delayLength;
    private int cachedToMine;
    private boolean silkTouch;
    private boolean running;
    private int delayTicks;
    private boolean initCalc;
    private int numPowering;
    private boolean clientRendering;
    private final TileComponentChunkLoader<TileEntityDigitalMiner> chunkLoaderComponent;
    @Nullable
    private ChunkPos targetChunk;
    private MinerEnergyContainer energyContainer;
    private List<IInventorySlot> mainSlots;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityDigitalMiner(BlockPos pos, BlockState state) {
        super(MekanismBlocks.DIGITAL_MINER, pos, state);
        this.delayLength = MekanismConfig.general.minerTicksPerMine.get();
        this.initCalc = false;
        this.chunkLoaderComponent = new TileComponentChunkLoader<TileEntityDigitalMiner>(this);
        this.radius = 10;
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD, this));
        this.addDisabledCapabilities(ForgeCapabilities.ITEM_HANDLER);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MinerEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        this.mainSlots = new ArrayList<IInventorySlot>();
        IContentsListener mainSlotListener = () -> {
            listener.onContentsChanged();
            this.recheckOverflow = true;
        };
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection, side -> side == RelativeSide.TOP, side -> side == RelativeSide.BACK);
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert = (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isReplaceTarget(stack.m_41720_());
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract = (stack, automationType) -> automationType != AutomationType.EXTERNAL || !this.isReplaceTarget(stack.m_41720_());
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                BasicInventorySlot slot = BasicInventorySlot.at(canExtract, canInsert, mainSlotListener, 8 + slotX * 18, 92 + slotY * 18);
                builder.addSlot(slot, RelativeSide.BACK, RelativeSide.TOP);
                this.mainSlots.add(slot);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityDigitalMiner)this).m_58904_(), listener, 152, 20);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    private void closeInvalidScreens() {
        if (this.getActive() && !this.playersUsing.isEmpty()) {
            for (Player player : new ObjectOpenHashSet((Collection)this.playersUsing)) {
                if (!(player.f_36096_ instanceof DigitalMinerConfigContainer)) continue;
                player.m_6915_();
            }
        }
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        this.closeInvalidScreens();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.closeInvalidScreens();
        if (!this.initCalc) {
            if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
                boolean prevRunning = this.running;
                this.reset();
                this.start();
                this.running = prevRunning;
            }
            this.initCalc = true;
        }
        this.energySlot.fillContainerOrConvert();
        if (this.recheckOverflow) {
            this.tryAddOverflow();
        }
        if (!this.hasOverflow && MekanismUtils.canFunction(this) && this.running && this.searcher.state == ThreadMinerSearch.State.FINISHED && !this.oresToMine.isEmpty()) {
            FloatingLong energyPerTick = this.energyContainer.getEnergyPerTick();
            if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                this.setActive(true);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                if (this.delay == 0) {
                    this.tryMineBlock();
                    this.delay = this.getDelay();
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        if (this.doEject && this.delayTicks == 0) {
            Direction oppositeDirection = this.getOppositeDirection();
            BlockEntity ejectInv = WorldUtils.getTileEntity((BlockGetter)this.f_58857_, this.m_58899_().m_7494_().m_5484_(oppositeDirection, 2));
            BlockEntity ejectTile = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), this.m_58899_().m_7494_().m_121945_(oppositeDirection));
            if (ejectInv != null && ejectTile != null) {
                TileTransitRequest ejectMap = InventoryUtils.getEjectItemMap(ejectTile, oppositeDirection, this.mainSlots);
                if (!ejectMap.isEmpty()) {
                    TransitRequest.TransitResponse response;
                    if (ejectInv instanceof TileEntityLogisticalTransporterBase) {
                        TileEntityLogisticalTransporterBase transporter = (TileEntityLogisticalTransporterBase)ejectInv;
                        response = transporter.getTransmitter().insert(ejectTile, (TransitRequest)ejectMap, transporter.getTransmitter().getColor(), true, 0);
                    } else {
                        response = ejectMap.addToInventory(ejectInv, oppositeDirection, 0, false);
                    }
                    if (!response.isEmpty()) {
                        response.useAll();
                    }
                }
                this.delayTicks = 10;
            }
        } else if (this.delayTicks > 0) {
            --this.delayTicks;
        }
    }

    public void updateFromSearch(Long2ObjectMap<BitSet> oresToMine, int found) {
        this.oresToMine = oresToMine;
        this.cachedToMine = found;
        this.updateTargetChunk(null);
        this.markForSave();
    }

    public int getDelay() {
        return this.delayLength;
    }

    @ComputerMethod
    public boolean getSilkTouch() {
        return this.silkTouch;
    }

    @ComputerMethod
    public int getRadius() {
        return this.radius;
    }

    @ComputerMethod
    public int getMinY() {
        return this.minY;
    }

    @ComputerMethod
    public int getMaxY() {
        return this.maxY;
    }

    @ComputerMethod(nameOverride="getInverseMode")
    public boolean getInverse() {
        return this.inverse;
    }

    @ComputerMethod(nameOverride="getInverseModeRequiresReplacement")
    public boolean getInverseRequiresReplacement() {
        return this.inverseRequiresReplacement;
    }

    @ComputerMethod(nameOverride="getInverseModeReplaceTarget")
    public Item getInverseReplaceTarget() {
        return this.inverseReplaceTarget;
    }

    private void setSilkTouch(boolean newSilkTouch) {
        if (this.silkTouch != newSilkTouch) {
            this.silkTouch = newSilkTouch;
            if (this.m_58898_() && !this.isRemote()) {
                this.energyContainer.updateMinerEnergyPerTick();
            }
        }
    }

    public void toggleSilkTouch() {
        this.setSilkTouch(!this.getSilkTouch());
        this.markForSave();
    }

    public void toggleInverse() {
        this.inverse = !this.inverse;
        this.markForSave();
    }

    public void toggleInverseRequiresReplacement() {
        this.inverseRequiresReplacement = !this.inverseRequiresReplacement;
        this.markForSave();
    }

    public void setInverseReplaceTarget(Item target) {
        if (target != this.inverseReplaceTarget) {
            this.inverseReplaceTarget = target;
            this.markForSave();
        }
    }

    public void toggleAutoEject() {
        this.doEject = !this.doEject;
        this.markForSave();
    }

    public void toggleAutoPull() {
        this.doPull = !this.doPull;
        this.markForSave();
    }

    public void setRadiusFromPacket(int newRadius) {
        this.setRadius(Mth.m_14045_((int)newRadius, (int)0, (int)MekanismConfig.general.minerMaxRadius.get()));
        this.sendUpdatePacket();
        this.markForSave();
    }

    private void setRadius(int newRadius) {
        if (this.radius != newRadius) {
            this.radius = newRadius;
            if (this.m_58898_() && !this.isRemote()) {
                this.energyContainer.updateMinerEnergyPerTick();
                this.getChunkLoader().refreshChunkTickets();
            }
        }
    }

    public void setMinYFromPacket(int newMinY) {
        if (this.f_58857_ != null) {
            this.setMinY(Mth.m_14045_((int)newMinY, (int)this.f_58857_.m_141937_(), (int)this.getMaxY()));
            this.sendUpdatePacket();
            this.markForSave();
        }
    }

    private void setMinY(int newMinY) {
        if (this.minY != newMinY) {
            this.minY = newMinY;
            if (this.m_58898_() && !this.isRemote()) {
                this.energyContainer.updateMinerEnergyPerTick();
            }
        }
    }

    public void setMaxYFromPacket(int newMaxY) {
        if (this.f_58857_ != null) {
            this.setMaxY(Mth.m_14045_((int)newMaxY, (int)this.getMinY(), (int)(this.f_58857_.m_151558_() - 1)));
            this.sendUpdatePacket();
            this.markForSave();
        }
    }

    private void setMaxY(int newMaxY) {
        if (this.maxY != newMaxY) {
            this.maxY = newMaxY;
            if (this.m_58898_() && !this.isRemote()) {
                this.energyContainer.updateMinerEnergyPerTick();
            }
        }
    }

    private void tryMineBlock() {
        BlockPos startingPos = this.getStartingPos();
        int diameter = this.getDiameter();
        long target = this.targetChunk == null ? ChunkPos.f_45577_ : this.targetChunk.m_45588_();
        ObjectIterator it = this.oresToMine.long2ObjectEntrySet().iterator();
        block0: while (it.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long chunk = entry.getLongKey();
            BitSet chunkToMine = (BitSet)entry.getValue();
            ChunkPos currentChunk = null;
            if (target == chunk) {
                currentChunk = this.targetChunk;
            }
            int previous = chunkToMine.length() - 1;
            while (true) {
                BlockState state;
                BlockPos pos;
                Optional<BlockState> blockState;
                int index;
                if ((index = chunkToMine.previousSetBit(previous)) == -1) {
                    it.remove();
                    continue block0;
                }
                if (currentChunk == null) {
                    currentChunk = new ChunkPos(chunk);
                    this.updateTargetChunk(currentChunk);
                    target = chunk;
                }
                if ((blockState = WorldUtils.getBlockState((BlockGetter)this.f_58857_, pos = TileEntityDigitalMiner.getOffsetForIndex(startingPos, diameter, index))).isPresent() && !(state = blockState.get()).m_60795_() && !state.m_204336_(MekanismTags.Blocks.MINER_BLACKLIST)) {
                    MinerFilter matchingFilter = null;
                    for (MinerFilter filter : this.filterManager.getEnabledFilters()) {
                        if (!filter.canFilter(state)) continue;
                        matchingFilter = filter;
                        break;
                    }
                    if (this.inverse == (matchingFilter == null) && this.canMine(state, pos)) {
                        List<ItemStack> drops = this.getDrops(state, pos);
                        if (this.canInsert(drops)) {
                            CommonWorldTickHandler.fallbackItemCollector = this.overflowCollector;
                            if (this.setReplace(state, pos, matchingFilter)) {
                                this.add(drops);
                                this.tryAddOverflow();
                                this.missingStack = ItemStack.f_41583_;
                                this.f_58857_.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                                --this.cachedToMine;
                                chunkToMine.clear(index);
                                if (chunkToMine.isEmpty()) {
                                    it.remove();
                                    this.updateTargetChunk(null);
                                }
                            }
                            CommonWorldTickHandler.fallbackItemCollector = null;
                        }
                        return;
                    }
                }
                --this.cachedToMine;
                chunkToMine.clear(index);
                if (chunkToMine.isEmpty()) {
                    it.remove();
                    continue block0;
                }
                previous = index - 1;
            }
        }
        this.updateTargetChunk(null);
    }

    private boolean setReplace(BlockState state, BlockPos pos, @Nullable MinerFilter<?> filter) {
        ItemStack stack;
        Item replaceTarget;
        if (this.f_58857_ == null) {
            return false;
        }
        if (filter == null) {
            replaceTarget = this.inverseReplaceTarget;
            stack = this.getReplace(replaceTarget, this::inverseReplaceTargetMatches);
        } else {
            replaceTarget = filter.replaceTarget;
            stack = this.getReplace(replaceTarget, filter::replaceTargetMatches);
        }
        if (stack.m_41619_()) {
            if (replaceTarget == Items.f_41852_ || filter == null && !this.inverseRequiresReplacement || filter != null && !filter.requiresReplacement) {
                this.f_58857_.m_7471_(pos, false);
                this.f_58857_.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_(null, (BlockState)state));
                return true;
            }
            this.missingStack = new ItemStack((ItemLike)replaceTarget);
            return false;
        }
        BlockState newState = this.withFakePlayer(fakePlayer -> StackUtils.getStateForPlacement(stack, pos, (Player)fakePlayer));
        if (newState == null || !newState.m_60710_((LevelReader)this.f_58857_, pos)) {
            return false;
        }
        this.f_58857_.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_(null, (BlockState)state));
        this.f_58857_.m_46597_(pos, newState);
        this.f_58857_.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_(null, (BlockState)newState));
        return true;
    }

    private boolean canMine(BlockState state, BlockPos pos) {
        return this.withFakePlayer(dummy -> !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.f_58857_, pos, state, (Player)dummy)));
    }

    private <R> R withFakePlayer(Function<MekFakePlayer, R> fakePlayerConsumer) {
        return (R)MekFakePlayer.withFakePlayer((ServerLevel)this.f_58857_, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), dummy -> {
            dummy.setEmulatingUUID(this.getOwnerUUID());
            return fakePlayerConsumer.apply((MekFakePlayer)((Object)dummy));
        });
    }

    private ItemStack getReplace(Item replaceTarget, Predicate<Item> replaceStackMatches) {
        TransitRequest.TransitResponse response;
        TransitRequest request;
        BlockEntity pullInv;
        if (replaceTarget == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        for (IInventorySlot slot : this.mainSlots) {
            ItemStack slotStack = slot.getStack();
            if (!replaceStackMatches.test(slotStack.m_41720_())) continue;
            MekanismUtils.logMismatchedStackSize(slot.shrinkStack(1, Action.EXECUTE), 1L);
            return StackUtils.size(slotStack, 1);
        }
        if ((replaceTarget == Items.f_42594_ || replaceTarget == Items.f_41905_) && this.upgradeComponent.isUpgradeInstalled(Upgrade.STONE_GENERATOR)) {
            return new ItemStack((ItemLike)replaceTarget);
        }
        if (this.doPull && (pullInv = this.getPullInv()) != null && InventoryUtils.isItemHandler(pullInv, Direction.DOWN) && !(request = TransitRequest.definedItem(pullInv, Direction.DOWN, 1, Finder.item(replaceTarget))).isEmpty() && (response = request.createSimpleResponse()).useAll().m_41619_()) {
            return StackUtils.size(response.getStack(), 1);
        }
        return ItemStack.f_41583_;
    }

    public boolean canInsert(List<ItemStack> toInsert) {
        if (toInsert.isEmpty()) {
            return true;
        }
        int slots = this.mainSlots.size();
        Int2ObjectOpenHashMap cachedStacks = new Int2ObjectOpenHashMap(slots);
        for (int i = 0; i < slots; ++i) {
            IInventorySlot slot = this.mainSlots.get(i);
            if (slot.isEmpty()) continue;
            cachedStacks.put(i, (Object)new ItemCount(slot.getStack(), slot.getCount()));
        }
        for (ItemStack stackToInsert : toInsert) {
            ItemStack stack = this.simulateInsert((Int2ObjectMap<ItemCount>)cachedStacks, slots, stackToInsert);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private ItemStack simulateInsert(Int2ObjectMap<ItemCount> cachedStacks, int slots, ItemStack stackToInsert) {
        int i;
        if (stackToInsert.m_41619_()) {
            return stackToInsert;
        }
        ItemStack stack = stackToInsert.m_41777_();
        for (i = 0; i < slots; ++i) {
            IInventorySlot slot;
            int limit;
            ItemCount cachedItem = (ItemCount)cachedStacks.get(i);
            if (cachedItem == null || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)cachedItem.stack) || cachedItem.count >= (limit = (slot = this.mainSlots.get(i)).getLimit(stack))) continue;
            cachedItem.count += stack.m_41613_();
            if (cachedItem.count <= limit) {
                return ItemStack.f_41583_;
            }
            stack = StackUtils.size(stack, cachedItem.count - limit);
            cachedItem.count = limit;
        }
        for (i = 0; i < slots; ++i) {
            if (cachedStacks.containsKey(i)) continue;
            IInventorySlot slot = this.mainSlots.get(i);
            int stackSize = stack.m_41613_();
            int remainderSize = (stack = slot.insertItem(stack, Action.SIMULATE, AutomationType.INTERNAL)).m_41613_();
            if (remainderSize >= stackSize) continue;
            cachedStacks.put(i, (Object)new ItemCount(stackToInsert, stackSize - remainderSize));
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    private BlockEntity getPullInv() {
        return WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), this.m_58899_().m_6630_(2));
    }

    private void add(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if ((stack = InventoryUtils.insertItem(this.mainSlots, stack, Action.EXECUTE, AutomationType.INTERNAL)).m_41619_()) continue;
            this.trackOverflow(stack);
        }
    }

    private boolean trackOverflow(ItemStack stack) {
        if (!stack.m_41619_()) {
            this.overflow.mergeInt((Object)HashedItem.create(stack), stack.m_41613_(), Integer::sum);
            this.hasOverflow = true;
            this.recheckOverflow = true;
            this.markForSave();
            return true;
        }
        return false;
    }

    private void tryAddOverflow() {
        if (this.hasOverflow) {
            boolean recheck = false;
            ObjectIterator iter = this.overflow.object2IntEntrySet().iterator();
            while (iter.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iter.next();
                int amount = entry.getIntValue();
                ItemStack stack = ((HashedItem)entry.getKey()).createStack(amount);
                if ((stack = InventoryUtils.insertItem(this.mainSlots, stack, Action.EXECUTE, AutomationType.INTERNAL)).m_41619_()) {
                    iter.remove();
                    recheck = true;
                    continue;
                }
                if (stack.m_41613_() == amount) continue;
                entry.setValue(stack.m_41613_());
            }
            if (recheck) {
                this.hasOverflow = !this.overflow.isEmpty();
            }
        }
        this.recheckOverflow = false;
    }

    public void start() {
        if (this.m_58904_() == null) {
            return;
        }
        if (this.searcher.state == ThreadMinerSearch.State.IDLE) {
            BlockPos startingPos = this.getStartingPos();
            int diameter = this.getDiameter();
            this.searcher.setChunkCache(new PathNavigationRegion(this.m_58904_(), startingPos, startingPos.m_7918_(diameter, this.getMaxY() - this.getMinY() + 1, diameter)));
            this.searcher.start();
        }
        this.running = true;
        this.markForSave();
    }

    public void stop() {
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.searcher.interrupt();
            this.reset();
        } else if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
            this.running = false;
            this.markForSave();
            this.updateTargetChunk(null);
        }
    }

    public void reset() {
        this.searcher = new ThreadMinerSearch(this);
        this.running = false;
        this.cachedToMine = 0;
        this.oresToMine = Long2ObjectMaps.emptyMap();
        this.missingStack = ItemStack.f_41583_;
        this.setActive(false);
        this.updateTargetChunk(null);
        this.markForSave();
    }

    public boolean isReplaceTarget(Item target) {
        if (this.inverse) {
            return this.inverseReplaceTargetMatches(target);
        }
        return this.filterManager.anyEnabledMatch(filter -> filter.replaceTargetMatches(target));
    }

    private boolean inverseReplaceTargetMatches(Item target) {
        return this.inverseReplaceTarget != Items.f_41852_ && this.inverseReplaceTarget == target;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.running = nbt.m_128471_("running");
        this.delay = nbt.m_128451_("delay");
        this.numPowering = nbt.m_128451_("numPowering");
        NBTUtils.setEnumIfPresent(nbt, "state", ThreadMinerSearch.State::byIndexStatic, s -> {
            if (!this.initCalc && s == ThreadMinerSearch.State.SEARCHING) {
                s = ThreadMinerSearch.State.FINISHED;
            }
            this.searcher.state = s;
        });
        this.energyContainer.updateMinerEnergyPerTick();
    }

    @Override
    public void m_142339_(@NotNull Level world) {
        super.m_142339_(world);
        this.energyContainer.updateMinerEnergyPerTick();
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128379_("running", this.running);
        nbtTags.m_128405_("delay", this.delay);
        nbtTags.m_128405_("numPowering", this.numPowering);
        NBTUtils.writeEnum(nbtTags, "state", this.searcher.state);
        if (!this.overflow.isEmpty()) {
            ListTag overflowTag = new ListTag();
            for (Object2IntMap.Entry entry : this.overflow.object2IntEntrySet()) {
                CompoundTag overflowComponent = new CompoundTag();
                overflowComponent.m_128365_("type", (Tag)((HashedItem)entry.getKey()).internalToNBT());
                overflowComponent.m_128405_("Count", entry.getIntValue());
                overflowTag.add((Object)overflowComponent);
            }
            nbtTags.m_128365_("overflow", (Tag)overflowTag);
        }
    }

    public int getTotalSize() {
        int diameter = this.getDiameter();
        return diameter * diameter * (this.getMaxY() - this.getMinY() + 1);
    }

    public int getDiameter() {
        return this.radius * 2 + 1;
    }

    public BlockPos getStartingPos() {
        return new BlockPos(this.m_58899_().m_123341_() - this.radius, this.getMinY(), this.m_58899_().m_123343_() - this.radius);
    }

    public static BlockPos getOffsetForIndex(BlockPos start, int diameter, int index) {
        return start.m_7918_(index % diameter, index / diameter / diameter, index / diameter % diameter);
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @NotNull
    public AABB getRenderBoundingBox() {
        if (this.isClientRendering() && this.canDisplayVisuals()) {
            return new AABB((double)(this.f_58858_.m_123341_() - this.radius), (double)this.minY, (double)(this.f_58858_.m_123343_() - this.radius), (double)(this.f_58858_.m_123341_() + this.radius + 1), (double)(this.maxY + 1), (double)(this.f_58858_.m_123343_() + this.radius + 1));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public boolean isClientRendering() {
        return this.clientRendering;
    }

    @Override
    public void toggleClientRendering() {
        this.clientRendering = !this.clientRendering;
    }

    @Override
    public boolean canDisplayVisuals() {
        return this.getRadius() <= 64;
    }

    @Override
    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    @Override
    public int getBoundingComparatorSignal(Vec3i offset) {
        Direction facing = this.getDirection();
        Direction back = facing.m_122424_();
        if (offset.equals((Object)new Vec3i(back.m_122429_(), 1, back.m_122431_()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction left = MekanismUtils.getLeft(facing);
        if (offset.equals((Object)new Vec3i(left.m_122429_(), 0, left.m_122431_()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction right = left.m_122424_();
        if (offset.equals((Object)new Vec3i(right.m_122429_(), 0, right.m_122431_()))) {
            return this.getCurrentRedstoneLevel();
        }
        return 0;
    }

    @Override
    protected void notifyComparatorChange() {
        super.notifyComparatorChange();
        Direction facing = this.getDirection();
        Direction left = MekanismUtils.getLeft(facing);
        this.f_58857_.m_46717_(this.f_58858_.m_121945_(left), (Block)MekanismBlocks.BOUNDING_BLOCK.getBlock());
        this.f_58857_.m_46717_(this.f_58858_.m_121945_(left.m_122424_()), (Block)MekanismBlocks.BOUNDING_BLOCK.getBlock());
        this.f_58857_.m_46717_(this.f_58858_.m_121945_(facing.m_122424_()).m_7494_(), (Block)MekanismBlocks.BOUNDING_BLOCK.getBlock());
    }

    @Override
    public void configurationDataSet() {
        super.configurationDataSet();
        if (this.isRunning()) {
            this.stop();
            this.reset();
            this.start();
        }
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        dataMap.m_128405_("radius", this.getRadius());
        dataMap.m_128405_("min", this.getMinY());
        dataMap.m_128405_("max", this.getMaxY());
        dataMap.m_128379_("eject", this.doEject);
        dataMap.m_128379_("pull", this.doPull);
        dataMap.m_128379_("silkTouch", this.getSilkTouch());
        dataMap.m_128379_("inverse", this.inverse);
        if (this.inverseReplaceTarget != Items.f_41852_) {
            NBTUtils.writeRegistryEntry(dataMap, "replaceStack", ForgeRegistries.ITEMS, this.inverseReplaceTarget);
        }
        dataMap.m_128379_("inverseReplace", this.inverseRequiresReplacement);
        this.filterManager.writeToNBT(dataMap);
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        this.setRadius(Math.min(dataMap.m_128451_("radius"), MekanismConfig.general.minerMaxRadius.get()));
        NBTUtils.setIntIfPresent(dataMap, "min", newMinY -> {
            if (this.m_58898_() && !this.isRemote()) {
                this.setMinY(Math.max(newMinY, this.f_58857_.m_141937_()));
            } else {
                this.setMinY(newMinY);
            }
        });
        NBTUtils.setIntIfPresent(dataMap, "max", newMaxY -> {
            if (this.m_58898_() && !this.isRemote()) {
                this.setMaxY(Math.min(newMaxY, this.f_58857_.m_151558_() - 1));
            } else {
                this.setMaxY(newMaxY);
            }
        });
        NBTUtils.setBooleanIfPresent(dataMap, "eject", eject -> {
            this.doEject = eject;
        });
        NBTUtils.setBooleanIfPresent(dataMap, "pull", pull -> {
            this.doPull = pull;
        });
        NBTUtils.setBooleanIfPresent(dataMap, "silkTouch", this::setSilkTouch);
        NBTUtils.setBooleanIfPresent(dataMap, "inverse", inverse -> {
            this.inverse = inverse;
        });
        this.inverseReplaceTarget = NBTUtils.readRegistryEntry(dataMap, "replaceStack", ForgeRegistries.ITEMS, Items.f_41852_);
        NBTUtils.setBooleanIfPresent(dataMap, "inverseReplace", requiresReplace -> {
            this.inverseRequiresReplacement = requiresReplace;
        });
        this.filterManager.readFromNBT(dataMap);
        NBTUtils.setListIfPresent(dataMap, "overflow", 10, overflowTag -> {
            this.overflow.clear();
            int size = overflowTag.size();
            for (int i = 0; i < size; ++i) {
                CompoundTag type;
                ItemStack stack;
                CompoundTag overflowComponent = overflowTag.m_128728_(i);
                int count = overflowComponent.m_128451_("Count");
                if (count <= 0 || (stack = ItemStack.m_41712_((CompoundTag)(type = overflowComponent.m_128469_("type")))).m_41619_()) continue;
                this.overflow.put((Object)HashedItem.raw(stack), count);
            }
            this.recheckOverflow = this.hasOverflow = !this.overflow.isEmpty();
        });
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("radius", "radius");
        remap.put("min", "min");
        remap.put("max", "max");
        remap.put("eject", "eject");
        remap.put("pull", "pull");
        remap.put("silkTouch", "silkTouch");
        remap.put("inverse", "inverse");
        remap.put("replaceStack", "replaceStack");
        remap.put("inverseReplace", "inverseReplace");
        remap.put("filters", "filters");
        remap.put("overflow", "overflow");
        return remap;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.delayLength = MekanismUtils.getTicks(this, MekanismConfig.general.minerTicksPerMine.get());
        }
    }

    @Override
    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getOffsetCapabilityIfEnabled(@NotNull Capability<T> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerManager.resolve(capability, side);
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@NotNull Capability<?> capability, Direction side, @NotNull Vec3i offset) {
        if (!capability.isRegistered()) {
            return true;
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.notItemPort(side, offset);
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            return this.notEnergyPort(side, offset);
        }
        if (this.canEverResolve(capability) && IBoundingBlock.super.isOffsetCapabilityDisabled(capability, side, offset)) {
            return this.notItemPort(side, offset) && this.notEnergyPort(side, offset);
        }
        return false;
    }

    private boolean notItemPort(Direction side, Vec3i offset) {
        if (offset.equals((Object)new Vec3i(0, 1, 0))) {
            return side != Direction.UP;
        }
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.m_122429_(), 1, back.m_122431_()))) {
            return side != back;
        }
        return true;
    }

    private boolean notEnergyPort(Direction side, Vec3i offset) {
        if (offset.equals((Object)Vec3i.f_123288_)) {
            return side != Direction.DOWN;
        }
        Direction left = this.getLeftSide();
        if (offset.equals((Object)new Vec3i(left.m_122429_(), 0, left.m_122431_()))) {
            return side != left;
        }
        Direction right = left.m_122424_();
        if (offset.equals((Object)new Vec3i(right.m_122429_(), 0, right.m_122431_()))) {
            return side != right;
        }
        return true;
    }

    public TileComponentChunkLoader<TileEntityDigitalMiner> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    private void updateTargetChunk(@Nullable ChunkPos target) {
        if (!Objects.equals(this.targetChunk, target)) {
            this.targetChunk = target;
            this.getChunkLoader().refreshChunkTickets();
        }
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        ChunkPos minerChunk = new ChunkPos(this.f_58858_);
        if (this.targetChunk != null && SectionPos.m_123171_((int)(this.f_58858_.m_123341_() - this.radius)) <= this.targetChunk.f_45578_ && this.targetChunk.f_45578_ <= SectionPos.m_123171_((int)(this.f_58858_.m_123341_() + this.radius)) && SectionPos.m_123171_((int)(this.f_58858_.m_123343_() - this.radius)) <= this.targetChunk.f_45579_ && this.targetChunk.f_45579_ <= SectionPos.m_123171_((int)(this.f_58858_.m_123343_() + this.radius))) {
            if (minerChunk.equals((Object)this.targetChunk)) {
                return Set.of(minerChunk);
            }
            return Set.of(minerChunk, this.targetChunk);
        }
        return Collections.singleton(minerChunk);
    }

    @Override
    public SortableFilterManager<MinerFilter<?>> getFilterManager() {
        return this.filterManager;
    }

    public MinerEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod
    public int getToMine() {
        return !this.isRemote() && this.searcher.state == ThreadMinerSearch.State.SEARCHING ? this.searcher.found : this.cachedToMine;
    }

    @ComputerMethod
    public boolean isRunning() {
        return this.running;
    }

    @ComputerMethod(nameOverride="getAutoEject")
    public boolean getDoEject() {
        return this.doEject;
    }

    @ComputerMethod(nameOverride="getAutoPull")
    public boolean getDoPull() {
        return this.doPull;
    }

    public boolean hasOverflow() {
        return this.hasOverflow;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        this.addConfigContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getDoEject, value -> {
            this.doEject = value;
        }));
        container.track(SyncableBoolean.create(this::getDoPull, value -> {
            this.doPull = value;
        }));
        container.track(SyncableBoolean.create(this::isRunning, value -> {
            this.running = value;
        }));
        container.track(SyncableBoolean.create(this::getSilkTouch, this::setSilkTouch));
        container.track(SyncableEnum.create(ThreadMinerSearch.State::byIndexStatic, ThreadMinerSearch.State.IDLE, () -> this.searcher.state, value -> {
            this.searcher.state = value;
        }));
        container.track(SyncableInt.create(this::getToMine, value -> {
            this.cachedToMine = value;
        }));
        container.track(SyncableItemStack.create(() -> this.missingStack, value -> {
            this.missingStack = value;
        }));
        container.track(SyncableBoolean.create(this::hasOverflow, value -> {
            this.hasOverflow = value;
        }));
    }

    public void addConfigContainerTrackers(MekanismContainer container) {
        container.track(SyncableInt.create(this::getRadius, this::setRadius));
        container.track(SyncableInt.create(this::getMinY, this::setMinY));
        container.track(SyncableInt.create(this::getMaxY, this::setMaxY));
        container.track(SyncableBoolean.create(this::getInverse, value -> {
            this.inverse = value;
        }));
        container.track(SyncableBoolean.create(this::getInverseRequiresReplacement, value -> {
            this.inverseRequiresReplacement = value;
        }));
        container.track(SyncableRegistryEntry.create(ForgeRegistries.ITEMS, this::getInverseReplaceTarget, value -> {
            this.inverseReplaceTarget = value;
        }));
        this.filterManager.addContainerTrackers(container);
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128405_("radius", this.getRadius());
        updateTag.m_128405_("min", this.getMinY());
        updateTag.m_128405_("max", this.getMaxY());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setIntIfPresent(tag, "radius", this::setRadius);
        NBTUtils.setIntIfPresent(tag, "min", this::setMinY);
        NBTUtils.setIntIfPresent(tag, "max", this::setMaxY);
    }

    private List<ItemStack> getDrops(BlockState state, BlockPos pos) {
        if (state.m_60795_()) {
            return Collections.emptyList();
        }
        ItemStack stack = MekanismItems.ATOMIC_DISASSEMBLER.getItemStack();
        if (this.getSilkTouch()) {
            stack.m_41663_(Enchantments.f_44985_, 1);
        }
        ServerLevel level = (ServerLevel)this.getWorldNN();
        return this.withFakePlayer(fakePlayer -> Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)WorldUtils.getTileEntity((BlockGetter)level, pos), (Entity)fakePlayer, (ItemStack)stack));
    }

    @ComputerMethod
    private FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }

    @ComputerMethod
    private int getSlotCount() {
        return this.mainSlots.size();
    }

    @ComputerMethod
    private ItemStack getItemInSlot(int slot) throws ComputerException {
        int slots = this.getSlotCount();
        if (slot < 0 || slot >= slots) {
            throw new ComputerException("Slot: '%d' is out of bounds, as this digital miner only has '%d' slots (zero indexed).", slot, slots);
        }
        return this.mainSlots.get(slot).getStack();
    }

    @ComputerMethod
    private ThreadMinerSearch.State getState() {
        return this.searcher.state;
    }

    @ComputerMethod
    private void setAutoEject(boolean eject) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.doEject != eject) {
            this.toggleAutoEject();
        }
    }

    @ComputerMethod
    private void setAutoPull(boolean pull) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.doPull != pull) {
            this.toggleAutoPull();
        }
    }

    @ComputerMethod(nameOverride="setSilkTouch")
    private void computerSetSilkTouch(boolean silk) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setSilkTouch(silk);
    }

    @ComputerMethod(nameOverride="start")
    private void computerStart() throws ComputerException {
        this.validateSecurityIsPublic();
        this.start();
    }

    @ComputerMethod(nameOverride="stop")
    private void computerStop() throws ComputerException {
        this.validateSecurityIsPublic();
        this.stop();
    }

    @ComputerMethod(nameOverride="reset")
    private void computerReset() throws ComputerException {
        this.validateSecurityIsPublic();
        this.reset();
    }

    @ComputerMethod
    private int getMaxRadius() {
        return MekanismConfig.general.minerMaxRadius.get();
    }

    private void validateCanChangeConfiguration() throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.searcher.state != ThreadMinerSearch.State.IDLE) {
            throw new ComputerException("Miner must be stopped and reset before its targeting configuration is changed.");
        }
    }

    @ComputerMethod(nameOverride="setRadius")
    private void computerSetRadius(int radius) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (radius < 0 || radius > MekanismConfig.general.minerMaxRadius.get()) {
            throw new ComputerException("Radius '%d' is out of range must be between 0 and %d. (Inclusive)", radius, MekanismConfig.general.minerMaxRadius.get());
        }
        this.setRadiusFromPacket(radius);
    }

    @ComputerMethod(nameOverride="setMinY")
    private void computerSetMinY(int minY) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.f_58857_ != null) {
            int min = this.f_58857_.m_141937_();
            if (minY < min || minY > this.getMaxY()) {
                throw new ComputerException("Min Y '%d' is out of range must be between %d and %d. (Inclusive)", minY, min, this.getMaxY());
            }
            this.setMinYFromPacket(minY);
        }
    }

    @ComputerMethod(nameOverride="setMaxY")
    private void computerSetMaxY(int maxY) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.f_58857_ != null) {
            int max = this.f_58857_.m_151558_() - 1;
            if (maxY < this.getMinY() || maxY > max) {
                throw new ComputerException("Max Y '%d' is out of range must be between %d and %d. (Inclusive)", maxY, this.getMinY(), max);
            }
            this.setMaxYFromPacket(maxY);
        }
    }

    @ComputerMethod
    private void setInverseMode(boolean enabled) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.inverse != enabled) {
            this.toggleInverse();
        }
    }

    @ComputerMethod
    private void setInverseModeRequiresReplacement(boolean requiresReplacement) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.inverseRequiresReplacement != requiresReplacement) {
            this.toggleInverseRequiresReplacement();
        }
    }

    @ComputerMethod
    private void setInverseModeReplaceTarget(Item target) throws ComputerException {
        this.validateCanChangeConfiguration();
        this.setInverseReplaceTarget(target);
    }

    @ComputerMethod
    private void clearInverseModeReplaceTarget() throws ComputerException {
        this.setInverseModeReplaceTarget(Items.f_41852_);
    }

    @ComputerMethod
    private List<MinerFilter<?>> getFilters() {
        return this.filterManager.getFilters();
    }

    @ComputerMethod
    private boolean addFilter(MinerFilter<?> filter) throws ComputerException {
        this.validateCanChangeConfiguration();
        return this.filterManager.addFilter(filter);
    }

    @ComputerMethod
    private boolean removeFilter(MinerFilter<?> filter) throws ComputerException {
        this.validateCanChangeConfiguration();
        return this.filterManager.removeFilter(filter);
    }

    private static class ItemCount {
        private final ItemStack stack;
        private int count;

        public ItemCount(ItemStack stack, int count) {
            this.stack = stack;
            this.count = count;
        }
    }
}

