/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import it.unimi.dsi.fastutil.booleans.Boolean2ObjectFunction;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.WorldConfig;
import mekanism.common.registration.impl.FeatureDeferredRegister;
import mekanism.common.registration.impl.FeatureRegistryObject;
import mekanism.common.registration.impl.SetupFeatureDeferredRegister;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.resource.ore.OreBlockType;
import mekanism.common.resource.ore.OreType;
import mekanism.common.util.EnumUtils;
import mekanism.common.world.ConfigurableConstantInt;
import mekanism.common.world.DisableableFeaturePlacement;
import mekanism.common.world.OreRetrogenFeature;
import mekanism.common.world.ResizableDiskConfig;
import mekanism.common.world.ResizableDiskReplaceFeature;
import mekanism.common.world.ResizableOreFeature;
import mekanism.common.world.ResizableOreFeatureConfig;
import mekanism.common.world.height.ConfigurableHeightProvider;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class MekanismFeatures {
    public static final FeatureDeferredRegister FEATURES = new FeatureDeferredRegister("mekanism");
    public static final SetupFeatureDeferredRegister SETUP_FEATURES = new SetupFeatureDeferredRegister("mekanism");
    public static final FeatureRegistryObject<ResizableDiskConfig, ResizableDiskReplaceFeature> DISK = FEATURES.register("disk", () -> new ResizableDiskReplaceFeature(ResizableDiskConfig.CODEC));
    public static final FeatureRegistryObject<ResizableOreFeatureConfig, ResizableOreFeature> ORE = FEATURES.register("ore", ResizableOreFeature::new);
    public static final FeatureRegistryObject<ResizableOreFeatureConfig, OreRetrogenFeature> ORE_RETROGEN = FEATURES.register("ore_retrogen", OreRetrogenFeature::new);
    private static final Map<OreType, List<OreConfiguration.TargetBlockState>> ORE_STONE_TARGETS = new EnumMap<OreType, List<OreConfiguration.TargetBlockState>>(OreType.class);
    public static final Map<OreType, SetupFeatureDeferredRegister.MekFeature<ResizableOreFeatureConfig, ResizableOreFeature>[]> ORES = new EnumMap<OreType, SetupFeatureDeferredRegister.MekFeature<ResizableOreFeatureConfig, ResizableOreFeature>[]>(OreType.class);
    public static final SetupFeatureDeferredRegister.MekFeature<ResizableDiskConfig, ResizableDiskReplaceFeature> SALT;

    private MekanismFeatures() {
    }

    private static ConfiguredFeature<ResizableOreFeatureConfig, ResizableOreFeature> configureOreFeature(OreType.OreVeinType oreVeinType, FeatureRegistryObject<ResizableOreFeatureConfig, ? extends ResizableOreFeature> featureRO) {
        WorldConfig.OreVeinConfig oreVeinConfig = MekanismConfig.world.getVeinConfig(oreVeinType);
        List targetStates = ORE_STONE_TARGETS.computeIfAbsent(oreVeinType.type(), oreType -> {
            OreBlockType oreBlockType = MekanismBlocks.ORES.get(oreType);
            return List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)oreBlockType.stoneBlock().m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)oreBlockType.deepslateBlock().m_49966_()));
        });
        return new ConfiguredFeature((Feature)((ResizableOreFeature)((Object)featureRO.get())), (FeatureConfiguration)new ResizableOreFeatureConfig(targetStates, oreVeinType, oreVeinConfig.maxVeinSize(), oreVeinConfig.discardChanceOnAirExposure()));
    }

    static {
        for (OreType type : EnumUtils.ORE_TYPES) {
            int features = type.getBaseConfigs().size();
            SetupFeatureDeferredRegister.MekFeature[] oreFeatures = new SetupFeatureDeferredRegister.MekFeature[features];
            for (int vein = 0; vein < features; ++vein) {
                OreType.OreVeinType oreVeinType = new OreType.OreVeinType(type, vein);
                oreFeatures[vein] = SETUP_FEATURES.register(oreVeinType.name(), () -> MekanismFeatures.configureOreFeature(oreVeinType, ORE), () -> MekanismFeatures.configureOreFeature(oreVeinType, ORE_RETROGEN), (Boolean2ObjectFunction<List<PlacementModifier>>)((Boolean2ObjectFunction)retrogen -> {
                    WorldConfig.OreVeinConfig oreVeinConfig = MekanismConfig.world.getVeinConfig(oreVeinType);
                    return List.of(new DisableableFeaturePlacement(oreVeinType, oreVeinConfig.shouldGenerate(), retrogen), CountPlacement.m_191630_((IntProvider)new ConfigurableConstantInt(oreVeinType, oreVeinConfig.perChunk())), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191683_((HeightProvider)ConfigurableHeightProvider.of(oreVeinType, oreVeinConfig)), BiomeFilter.m_191561_());
                }));
            }
            ORES.put(type, oreFeatures);
        }
        SALT = SETUP_FEATURES.register("salt", () -> new ConfiguredFeature((Feature)((ResizableDiskReplaceFeature)((Object)((Object)DISK.get()))), (FeatureConfiguration)new ResizableDiskConfig(MekanismBlocks.SALT_BLOCK.getBlock().m_49966_(), MekanismConfig.world.salt)), (Boolean2ObjectFunction<List<PlacementModifier>>)((Boolean2ObjectFunction)retrogen -> List.of(new DisableableFeaturePlacement(null, MekanismConfig.world.salt.shouldGenerate, retrogen), CountPlacement.m_191630_((IntProvider)new ConfigurableConstantInt(null, MekanismConfig.world.salt.perChunk)), InSquarePlacement.m_191715_(), retrogen ? PlacementUtils.f_195355_ : PlacementUtils.f_195353_, BiomeFilter.m_191561_())));
    }
}

