/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import mekanism.common.registration.WrappedDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TileEntityTypeDeferredRegister
extends WrappedDeferredRegister<BlockEntityType<?>> {
    public TileEntityTypeDeferredRegister(String modid) {
        super(modid, ForgeRegistries.BLOCK_ENTITY_TYPES);
    }

    public <BE extends TileEntityMekanism> TileEntityTypeRegistryObject<BE> register(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
        return this.builder(block, factory).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).build();
    }

    public <BE extends BlockEntity> BlockEntityTypeBuilder<BE> builder(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
        return new BlockEntityTypeBuilder<BE>(block, factory);
    }

    public class BlockEntityTypeBuilder<BE extends BlockEntity> {
        private final BlockRegistryObject<?, ?> block;
        private final BlockEntityType.BlockEntitySupplier<? extends BE> factory;
        @Nullable
        private BlockEntityTicker<BE> clientTicker;
        @Nullable
        private BlockEntityTicker<BE> serverTicker;

        private BlockEntityTypeBuilder(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
            this.block = block;
            this.factory = factory;
        }

        public BlockEntityTypeBuilder<BE> clientTicker(BlockEntityTicker<BE> ticker) {
            if (this.clientTicker != null) {
                throw new IllegalStateException("Client ticker may only be set once.");
            }
            this.clientTicker = ticker;
            return this;
        }

        public BlockEntityTypeBuilder<BE> serverTicker(BlockEntityTicker<BE> ticker) {
            if (this.serverTicker != null) {
                throw new IllegalStateException("Server ticker may only be set once.");
            }
            this.serverTicker = ticker;
            return this;
        }

        public BlockEntityTypeBuilder<BE> commonTicker(BlockEntityTicker<BE> ticker) {
            return this.clientTicker(ticker).serverTicker(ticker);
        }

        public TileEntityTypeRegistryObject<BE> build() {
            TileEntityTypeRegistryObject<BE> registryObject = new TileEntityTypeRegistryObject<BE>(null);
            registryObject.clientTicker(this.clientTicker).serverTicker(this.serverTicker);
            return (TileEntityTypeRegistryObject)TileEntityTypeDeferredRegister.this.register(this.block.getInternalRegistryName(), () -> BlockEntityType.Builder.m_155273_(this.factory, (Block[])new Block[]{this.block.getBlock()}).m_58966_(null), registryObject::setRegistryObject);
        }
    }
}

