/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.MultiChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.SingleChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.TaggedChemicalStackIngredient;
import mekanism.common.recipe.lookup.cache.type.BaseInputCache;

public class ChemicalInputCache<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends MekanismRecipe>
extends BaseInputCache<CHEMICAL, STACK, ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE> {
    @Override
    public boolean mapInputs(RECIPE recipe, ChemicalStackIngredient<CHEMICAL, STACK> inputIngredient) {
        if (inputIngredient instanceof SingleChemicalStackIngredient) {
            SingleChemicalStackIngredient single = (SingleChemicalStackIngredient)inputIngredient;
            Object input = single.getInputRaw();
            this.addInputCache(input, recipe);
        } else if (inputIngredient instanceof TaggedChemicalStackIngredient) {
            TaggedChemicalStackIngredient tagged = (TaggedChemicalStackIngredient)inputIngredient;
            for (Chemical input : tagged.getRawInput()) {
                this.addInputCache(input, recipe);
            }
        } else {
            if (inputIngredient instanceof MultiChemicalStackIngredient) {
                MultiChemicalStackIngredient multi = (MultiChemicalStackIngredient)inputIngredient;
                return this.mapMultiInputs(recipe, multi);
            }
            return true;
        }
        return false;
    }

    @Override
    protected CHEMICAL createKey(STACK stack) {
        return ((ChemicalStack)stack).getType();
    }

    @Override
    public boolean isEmpty(STACK input) {
        return ((ChemicalStack)input).isEmpty();
    }
}

