/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup;

import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.EitherSideInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.util.ChemicalUtil;
import org.jetbrains.annotations.Nullable;

public interface IEitherSideRecipeLookupHandler<INPUT, RECIPE extends MekanismRecipe, INPUT_CACHE extends EitherSideInputRecipeCache<INPUT, ?, RECIPE, ?>>
extends IRecipeLookupHandler.IRecipeTypedLookupHandler<RECIPE, INPUT_CACHE> {
    default public boolean containsRecipe(INPUT input) {
        return ((EitherSideInputRecipeCache)this.getRecipeType().getInputCache()).containsInput(this.getHandlerWorld(), input);
    }

    default public boolean containsRecipe(INPUT inputA, INPUT inputB) {
        return ((EitherSideInputRecipeCache)this.getRecipeType().getInputCache()).containsInput(this.getHandlerWorld(), inputA, inputB);
    }

    @Nullable
    default public RECIPE findFirstRecipe(INPUT inputA, INPUT inputB) {
        return ((EitherSideInputRecipeCache)this.getRecipeType().getInputCache()).findFirstRecipe(this.getHandlerWorld(), inputA, inputB);
    }

    @Nullable
    default public RECIPE findFirstRecipe(IInputHandler<INPUT> inputAHandler, IInputHandler<INPUT> inputBHandler) {
        return this.findFirstRecipe(inputAHandler.getInput(), inputBHandler.getInput());
    }

    public static interface EitherSideChemicalRecipeLookupHandler<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, ? extends ChemicalStackIngredient<CHEMICAL, STACK>>>
    extends IEitherSideRecipeLookupHandler<STACK, RECIPE, InputRecipeCache.EitherSideChemical<CHEMICAL, STACK, RECIPE>> {
        @Override
        default public boolean containsRecipe(CHEMICAL input) {
            return this.containsRecipe((CHEMICAL)ChemicalUtil.withAmount(input, 1L));
        }

        @Override
        default public boolean containsRecipe(CHEMICAL inputA, STACK inputB) {
            return this.containsRecipe((CHEMICAL)ChemicalUtil.withAmount(inputA, 1L), inputB);
        }
    }
}

