/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.PaintingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSPigment;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

@RecipeTypeMapper
public class PaintingMachineRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekPaintingMachine";
    }

    public String getDescription() {
        return "Maps Mekanism painting machine recipes.";
    }

    public boolean canHandle(RecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.PAINTING.get();
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, Recipe<?> iRecipe, INSSFakeGroupManager groupManager) {
        if (!(iRecipe instanceof PaintingRecipe)) {
            return false;
        }
        PaintingRecipe recipe = (PaintingRecipe)iRecipe;
        boolean handled = false;
        List<@NotNull TYPE> pigmentRepresentations = ((ChemicalStackIngredient.PigmentStackIngredient)recipe.getChemicalInput()).getRepresentations();
        List<@NotNull TYPE> itemRepresentations = recipe.getItemInput().getRepresentations();
        for (PigmentStack pigmentRepresentation : pigmentRepresentations) {
            NSSPigment nssPigment = NSSPigment.createPigment(pigmentRepresentation);
            for (ItemStack itemRepresentation : itemRepresentations) {
                ItemStack output = recipe.getOutput(itemRepresentation, pigmentRepresentation);
                if (output.m_41619_()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssPigment, pigmentRepresentation.getAmount());
                ingredientHelper.put(itemRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

