/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.jade;

import mekanism.common.block.BlockBounding;
import mekanism.common.entity.EntityRobit;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.integration.lookingat.jade.JadeConstants;
import mekanism.common.integration.lookingat.jade.JadeDataProvider;
import mekanism.common.integration.lookingat.jade.JadeEntityDataProvider;
import mekanism.common.integration.lookingat.jade.JadeTooltipRenderer;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class MekanismJadePlugin
implements IWailaPlugin {
    private static final ResourceLocation FORGE_ENERGY = new ResourceLocation("fe");
    private static final ResourceLocation NEW_ENERGY = new ResourceLocation("energy_storage");
    private static final ResourceLocation FORGE_FLUID = new ResourceLocation("fluid");

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)JadeDataProvider.INSTANCE, BlockEntity.class);
        registration.registerEntityDataProvider((IServerDataProvider)JadeEntityDataProvider.INSTANCE, EntityRobit.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(LookingAtUtils.ENERGY, true);
        registration.addConfig(LookingAtUtils.FLUID, true);
        registration.addConfig(LookingAtUtils.GAS, true);
        registration.addConfig(LookingAtUtils.INFUSE_TYPE, true);
        registration.addConfig(LookingAtUtils.PIGMENT, true);
        registration.addConfig(LookingAtUtils.SLURRY, true);
        registration.registerEntityComponent((IEntityComponentProvider)JadeTooltipRenderer.INSTANCE, EntityRobit.class);
        registration.registerBlockComponent((IBlockComponentProvider)JadeTooltipRenderer.INSTANCE, Block.class);
        registration.registerBlockComponent(new IBlockComponentProvider(){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                if (accessor.getServerData().m_128425_("mekData", 9)) {
                    tooltip.remove(FORGE_ENERGY);
                    tooltip.remove(NEW_ENERGY);
                    tooltip.remove(FORGE_FLUID);
                }
            }

            public ResourceLocation getUid() {
                return JadeConstants.REMOVE_BUILTIN;
            }

            public int getDefaultPriority() {
                return 10000;
            }
        }, Block.class);
        registration.addRayTraceCallback((hitResult, accessor, originalAccessor) -> {
            BlockHitResult blockHitResult;
            Level level;
            BlockPos mainPos;
            BlockAccessor target;
            if (accessor instanceof BlockAccessor && (target = (BlockAccessor)accessor).getBlockState().m_60734_() instanceof BlockBounding && (mainPos = BlockBounding.getMainBlockPos((BlockGetter)(level = target.getLevel()), (blockHitResult = (BlockHitResult)target.getHitResult()).m_82425_())) != null) {
                return registration.blockAccessor().from(target).hit(blockHitResult.m_82430_(mainPos)).blockState(level.m_8055_(mainPos)).blockEntity(WorldUtils.getTileEntity((BlockGetter)level, mainPos)).build();
            }
            return accessor;
        });
    }
}

